/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.l;
import com.google.android.gms.internal.o;
import com.google.android.gms.internal.p;
import com.google.android.gms.internal.s;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class k<T extends IInterface>
implements GooglePlayServicesClient {
    private final Context mContext;
    final Handler mHandler;
    private T bs;
    private ArrayList<GooglePlayServicesClient.ConnectionCallbacks> bt;
    final ArrayList<GooglePlayServicesClient.ConnectionCallbacks> bu = new ArrayList();
    private boolean bv = false;
    private ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> bw;
    private boolean bx = false;
    private final ArrayList<b<?>> by = new ArrayList();
    private e bz;
    private final String[] f;
    boolean bA = false;
    boolean bB = false;
    private final Object bC = new Object();
    public static final String[] bD = new String[]{"service_esmobile", "service_googleme"};

    protected k(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = s.d(context);
        this.bt = new ArrayList();
        this.bt.add(s.d(connectionCallbacks));
        this.bw = new ArrayList();
        this.bw.add(s.d(onConnectionFailedListener));
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.f = stringArray;
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String b();

    protected abstract String c();

    protected abstract T c(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.bA = true;
        Object object = this.bC;
        synchronized (object) {
            this.bB = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.bz != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.bs = null;
            l.g(this.mContext).b(this.b(), this.bz);
        }
        this.bz = new e();
        boolean bl2 = l.g(this.mContext).a(this.b(), this.bz);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.b()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.bs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.bC;
        synchronized (object) {
            return this.bB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.bA = false;
        ArrayList<b<?>> arrayList = this.bC;
        synchronized (arrayList) {
            this.bB = false;
        }
        arrayList = this.by;
        synchronized (arrayList) {
            int n2 = this.by.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.by.get(i2).E();
            }
            this.by.clear();
        }
        this.bs = null;
        if (this.bz != null) {
            l.g(this.mContext).b(this.b(), this.bz);
            this.bz = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] x() {
        return this.f;
    }

    protected final void f(IBinder iBinder) {
        try {
            p p2 = p.a.h(iBinder);
            this.a(p2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(p var1, d var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void y() {
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bt;
        synchronized (arrayList) {
            s.a(!this.bv);
            this.mHandler.removeMessages(4);
            this.bv = true;
            s.a(this.bu.size() == 0);
            Bundle bundle = this.z();
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.bt;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.bA && this.isConnected(); ++i2) {
                int n3 = this.bu.size();
                if (this.bu.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnected(bundle);
            }
            this.bu.clear();
            this.bv = false;
        }
    }

    protected Bundle z() {
        return null;
    }

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void A() {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bt;
        synchronized (arrayList) {
            this.bv = true;
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.bt;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.bA; ++i2) {
                if (!this.bt.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onDisconnected();
            }
            this.bv = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.bw;
        synchronized (arrayList) {
            this.bx = true;
            ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList2 = this.bw;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.bA) {
                    return;
                }
                if (!this.bw.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnectionFailed(connectionResult);
            }
            this.bx = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bt;
        synchronized (arrayList) {
            if (this.bt.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                if (this.bv) {
                    this.bt = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.bt);
                }
                this.bt.add(listener);
            }
        }
        if (this.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bt;
        synchronized (arrayList) {
            return this.bt.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bt;
        synchronized (arrayList) {
            if (this.bt != null) {
                boolean bl2;
                if (this.bv) {
                    this.bt = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.bt);
                }
                if (!(bl2 = this.bt.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
                } else if (this.bv && !this.bu.contains(listener)) {
                    this.bu.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.bw;
        synchronized (arrayList) {
            if (this.bw.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                if (this.bx) {
                    this.bw = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.bw);
                }
                this.bw.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.bw;
        synchronized (arrayList) {
            return this.bw.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        s.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.bw;
        synchronized (arrayList) {
            if (this.bw != null) {
                boolean bl2;
                if (this.bx) {
                    this.bw = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.bw);
                }
                if (!(bl2 = this.bw.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
                }
            }
        }
    }

    protected final void B() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    protected final T C() {
        this.B();
        return this.bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.by;
        synchronized (arrayList) {
            this.by.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    public static final class d
    extends o.a {
        private k bG;

        public d(k k2) {
            this.bG = k2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            s.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.bG);
            this.bG.a(n2, iBinder, bundle);
            this.bG = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle bH;
        public final IBinder bI;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.bI = iBinder;
            this.bH = bundle;
        }

        @Override
        protected void a(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.bI.getInterfaceDescriptor();
                        if (k.this.c().equals(string2)) {
                            k.this.bs = k.this.c(this.bI);
                            if (k.this.bs != null) {
                                k.this.y();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    l.g(k.this.mContext).b(k.this.b(), k.this.bz);
                    k.this.bz = null;
                    k.this.bs = null;
                    k.this.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.bH != null) {
                        pendingIntent = (PendingIntent)this.bH.getParcelable("pendingIntent");
                    }
                    if (k.this.bz != null) {
                        l.g(k.this.mContext).b(k.this.b(), k.this.bz);
                        k.this.bz = null;
                    }
                    k.this.bs = null;
                    k.this.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        private final com.google.android.gms.common.data.d S;

        public c(TListener TListener, com.google.android.gms.common.data.d d2) {
            super(TListener);
            this.S = d2;
        }

        @Override
        protected final void a(TListener TListener) {
            this.a(TListener, this.S);
        }

        protected abstract void a(TListener var1, com.google.android.gms.common.data.d var2);

        @Override
        protected void d() {
            if (this.S != null) {
                this.S.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean bF;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.bF = false;
        }

        protected abstract void a(TListener var1);

        protected abstract void d();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void D() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.bF) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.a(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.d();
                    throw runtimeException;
                }
            } else {
                this.d();
            }
            b2 = this;
            synchronized (b2) {
                this.bF = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.E();
            ArrayList arrayList = k.this.by;
            synchronized (arrayList) {
                k.this.by.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void E() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1 && !k.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.d();
                b2.unregister();
                return;
            }
            Object object = k.this.bC;
            synchronized (object) {
                k.this.bB = false;
            }
            if (msg.what == 3) {
                k.this.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                object = k.this.bt;
                synchronized (object) {
                    if (k.this.bA && k.this.isConnected() && k.this.bt.contains(msg.obj)) {
                        ((GooglePlayServicesClient.ConnectionCallbacks)msg.obj).onConnected(k.this.z());
                    }
                }
                return;
            }
            if (msg.what == 2 && !k.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).d();
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).D();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            k.this.f(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            k.this.bs = null;
            k.this.A();
        }
    }
}

