/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.bf;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.s;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.a;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bg {
    private final bk<bf> fG;
    private final ContentResolver mContentResolver;
    private ContentProviderClient fH = null;
    private boolean fI = false;
    private HashMap<LocationListener, b> fJ = new HashMap();

    public bg(Context context, bk<bf> bk2) {
        this.fG = bk2;
        this.mContentResolver = context.getContentResolver();
    }

    public Location getLastLocation() {
        this.fG.B();
        try {
            return this.fG.C().aQ();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.fG.B();
        if (looper == null) {
            s.b(Looper.myLooper(), (Object)"Can't create handler inside thread that has not called Looper.prepare()");
        }
        HashMap<LocationListener, b> hashMap = this.fJ;
        synchronized (hashMap) {
            b b2 = this.fJ.get(listener);
            if (b2 == null) {
                b2 = new b(listener, looper);
            }
            this.fJ.put(listener, b2);
            try {
                this.fG.C().a(request, b2);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.fG.B();
        try {
            this.fG.C().a(request, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationUpdates(LocationListener listener) {
        this.fG.B();
        s.b(listener, (Object)"Invalid null listener");
        HashMap<LocationListener, b> hashMap = this.fJ;
        synchronized (hashMap) {
            b b2 = this.fJ.remove(listener);
            if (this.fH != null && this.fJ.isEmpty()) {
                this.fH.release();
                this.fH = null;
            }
            if (b2 != null) {
                b2.release();
                try {
                    this.fG.C().a(b2);
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException(remoteException);
                }
            }
        }
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.fG.B();
        try {
            this.fG.C().a(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void setMockMode(boolean isMockMode) {
        this.fG.B();
        try {
            this.fG.C().setMockMode(isMockMode);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
        this.fI = isMockMode;
    }

    public void setMockLocation(Location mockLocation) {
        this.fG.B();
        try {
            this.fG.C().setMockLocation(mockLocation);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            HashMap<LocationListener, b> hashMap = this.fJ;
            synchronized (hashMap) {
                for (b b2 : this.fJ.values()) {
                    if (b2 == null) continue;
                    this.fG.C().a(b2);
                }
                this.fJ.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void aR() {
        if (this.fI) {
            this.setMockMode(false);
        }
    }

    private static class a
    extends Handler {
        private final LocationListener fK;

        public a(LocationListener locationListener) {
            this.fK = locationListener;
        }

        public a(LocationListener locationListener, Looper looper) {
            super(looper);
            this.fK = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.fK.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class b
    extends a.a {
        private Handler fL;

        b(LocationListener locationListener, Looper looper) {
            this.fL = looper == null ? new a(locationListener) : new a(locationListener, looper);
        }

        public void onLocationChanged(Location location) {
            if (this.fL == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.fL.sendMessage(message);
        }

        public void release() {
            this.fL = null;
        }
    }
}

