/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.RealTimeSocket;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.leaderboard.SubmitScoreResult;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.at;
import com.google.android.gms.internal.aw;
import com.google.android.gms.internal.ax;
import com.google.android.gms.internal.ay;
import com.google.android.gms.internal.az;
import com.google.android.gms.internal.ba;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.k;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class au
extends com.google.android.gms.internal.k<az> {
    private final String dz;
    private final String g;
    private final Map<String, bb> dA;
    private PlayerEntity dB;
    private GameEntity dC;
    private final ba dD;
    private boolean dE = false;
    private final Binder dF;
    private final long dG;
    private final boolean dH;

    public au(Context context, String string2, String string3, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.dz = string2;
        this.g = com.google.android.gms.internal.s.d(string3);
        this.dF = new Binder();
        this.dA = new HashMap<String, bb>();
        this.dD = ba.a(this, n2);
        this.setViewForPopups(view);
        this.dG = this.hashCode();
        this.dH = bl2;
    }

    public void setGravityForPopups(int gravity) {
        this.dD.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.dD.a(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            com.google.android.gms.internal.s.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            com.google.android.gms.internal.s.a(bl2, String.format("GamesClient requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.av();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.dE = false;
        if (this.isConnected()) {
            try {
                az az2 = (az)this.C();
                az2.ax();
                az2.b(this.dG);
                az2.a(this.dG);
            }
            catch (RemoteException remoteException) {
                ax.b("GamesClient", "Failed to notify client disconnect.");
            }
        }
        this.aw();
        super.disconnect();
    }

    @Override
    protected String b() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String c() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected az m(IBinder iBinder) {
        return az.a.o(iBinder);
    }

    @Override
    protected Bundle z() {
        try {
            Bundle bundle = ((az)this.C()).z();
            if (bundle != null) {
                bundle.setClassLoader(au.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return null;
        }
    }

    private void av() {
        this.dB = null;
    }

    @Override
    protected void a(com.google.android.gms.internal.p p2, k.d d2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.dH);
        p2.a(d2, 3265100, this.getContext().getPackageName(), this.g, this.x(), this.dz, this.dD.aD(), string2, bundle);
    }

    @Override
    protected void y() {
        super.y();
        if (this.dE) {
            this.dD.aB();
            this.dE = false;
        }
    }

    @Override
    protected void a(ConnectionResult connectionResult) {
        super.a(connectionResult);
        this.dE = false;
    }

    public String getCurrentAccountName() {
        try {
            return ((az)this.C()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((az)this.C()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.B();
        au au2 = this;
        synchronized (au2) {
            if (this.dB == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((az)this.C()).ay());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.dB = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    ax.b("GamesClient", "service died");
                }
            }
        }
        return this.dB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.B();
        au au2 = this;
        synchronized (au2) {
            if (this.dC == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((az)this.C()).aA());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.dC = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    ax.b("GamesClient", "service died");
                }
            }
        }
        return this.dC;
    }

    public void loadPlayer(OnPlayersLoadedListener listener, String playerId) {
        try {
            ((az)this.C()).c((ay)new ae(listener), playerId);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void a(OnPlayersLoadedListener onPlayersLoadedListener, int n2, boolean bl2, boolean bl3) {
        try {
            ((az)this.C()).a((ay)new ae(onPlayersLoadedListener), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARDS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.dz);
        intent.addFlags(0x4000000);
        return aw.b(intent);
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARD_SCORES");
        intent.putExtra("com.google.android.gms.games.LEADERBOARD_ID", leaderboardId);
        intent.addFlags(0x4000000);
        return aw.b(intent);
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, boolean forceReload) {
        try {
            ((az)this.C()).c((ay)new s(listener), forceReload);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, String leaderboardId, boolean forceReload) {
        try {
            ((az)this.C()).c((ay)new s(listener), leaderboardId, forceReload);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((az)this.C()).a(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((az)this.C()).b(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void loadMoreScores(OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        try {
            ((az)this.C()).a((ay)new q(listener), buffer.aF().aG(), maxResults, pageDirection);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void a(OnScoreSubmittedListener onScoreSubmittedListener, String string2, long l2) {
        try {
            ap ap2 = onScoreSubmittedListener == null ? null : new ap(onScoreSubmittedListener);
            ((az)this.C()).a((ay)ap2, string2, l2);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_ACHIEVEMENTS");
        intent.addFlags(0x4000000);
        return aw.b(intent);
    }

    public void loadAchievements(OnAchievementsLoadedListener listener, boolean forceReload) {
        try {
            ((az)this.C()).b((ay)new f(listener), forceReload);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((az)this.C()).a((ay)d2, string2, this.dD.aD(), this.dD.aC());
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void b(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((az)this.C()).b((ay)d2, string2, this.dD.aD(), this.dD.aC());
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2, int n2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((az)this.C()).a((ay)d2, string2, n2, this.dD.aD(), this.dD.aC());
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public Intent getInvitationInboxIntent() {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_INVITATIONS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.dz);
        return aw.b(intent);
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            l l2 = new l(listener);
            ((az)this.C()).a((ay)l2, this.dG);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((az)this.C()).b(this.dG);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.SELECT_PLAYERS");
        intent.putExtra("com.google.android.gms.games.MIN_SELECTIONS", minPlayers);
        intent.putExtra("com.google.android.gms.games.MAX_SELECTIONS", maxPlayers);
        return aw.b(intent);
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_REAL_TIME_WAITING_ROOM");
        com.google.android.gms.internal.s.b(room, (Object)"Room parameter must not be null");
        intent.putExtra("room", (Parcelable)room.freeze());
        com.google.android.gms.internal.s.a(minParticipantsToStart >= 0, "minParticipantsToStart must be >= 0");
        intent.putExtra("com.google.android.gms.games.MIN_PARTICIPANTS_TO_START", minParticipantsToStart);
        return aw.b(intent);
    }

    public Intent getSettingsIntent() {
        this.B();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_SETTINGS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.dz);
        intent.addFlags(0x4000000);
        return aw.b(intent);
    }

    public void loadGame(OnGamesLoadedListener listener) {
        try {
            ((az)this.C()).d(new j(listener));
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void signOut(OnSignOutCompleteListener listener) {
        try {
            an an2 = listener == null ? null : new an(listener);
            ((az)this.C()).a(an2);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public String getAppId() {
        try {
            return ((az)this.C()).getAppId();
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return null;
        }
    }

    public void loadInvitations(OnInvitationsLoadedListener listener) {
        try {
            ((az)this.C()).e(new n(listener));
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void h(String string2, int n2) {
        try {
            ((az)this.C()).h(string2, n2);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void i(String string2, int n2) {
        try {
            ((az)this.C()).i(string2, n2);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void createRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((az)this.C()).a((ay)aj2, (IBinder)this.dF, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.dG);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((az)this.C()).a((ay)aj2, (IBinder)this.dF, config.getInvitationId(), config.isSocketEnabled(), this.dG);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((az)this.C()).e(new aj(listener), roomId);
            this.aw();
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public int sendReliableRealTimeMessage(RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        try {
            return ((az)this.C()).a((ay)new ah(listener), messageData, roomId, recipientParticipantId);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        com.google.android.gms.internal.s.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((az)this.C()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((az)this.C()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.z(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        bb bb2 = this.dA.get(participantId);
        if (bb2 == null || bb2.isClosed()) {
            return this.t(participantId);
        }
        return bb2;
    }

    private bb t(String string2) {
        try {
            String string3 = ((az)this.C()).v(string2);
            if (string3 == null) {
                return null;
            }
            ax.d("GamesClient", "Creating a socket to bind to:" + string3);
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                ax.c("GamesClient", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            bb bb2 = new bb(localSocket, string2);
            this.dA.put(string2, bb2);
            return bb2;
        }
        catch (RemoteException remoteException) {
            ax.c("GamesClient", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((az)this.C()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    public void setUseNewPlayerNotificationsFirstParty(boolean newPlayerStyle) {
        try {
            ((az)this.C()).setUseNewPlayerNotificationsFirstParty(newPlayerStyle);
        }
        catch (RemoteException remoteException) {
            ax.b("GamesClient", "service died");
        }
    }

    private void aw() {
        for (bb bb2 : this.dA.values()) {
            try {
                bb2.close();
            }
            catch (IOException iOException) {
                ax.a("GamesClient", "IOException:", iOException);
            }
        }
        this.dA.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((az)this.C()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                ax.b("GamesClient", "service died");
            }
        }
    }

    public void ax() {
        if (this.isConnected()) {
            try {
                ((az)this.C()).ax();
            }
            catch (RemoteException remoteException) {
                ax.b("GamesClient", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room x(com.google.android.gms.common.data.d d2) {
        com.google.android.gms.games.multiplayer.realtime.a a2 = new com.google.android.gms.games.multiplayer.realtime.a(d2);
        Room room = null;
        try {
            if (a2.getCount() > 0) {
                room = (Room)((Room)a2.get(0)).freeze();
            }
        }
        finally {
            a2.close();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.dE = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface c(IBinder iBinder) {
        return this.m(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ao
    extends k.b<OnSignOutCompleteListener> {
        public ao(OnSignOutCompleteListener onSignOutCompleteListener) {
            super(au.this, onSignOutCompleteListener);
        }

        @Override
        public void a(OnSignOutCompleteListener onSignOutCompleteListener) {
            onSignOutCompleteListener.onSignOutComplete();
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends k.b<RealTimeReliableMessageSentListener> {
        private final int p;
        private final String dZ;
        private final int ea;

        ag(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener, int n2, int n3, String string2) {
            super(au.this, realTimeReliableMessageSentListener);
            this.p = n2;
            this.ea = n3;
            this.dZ = string2;
        }

        @Override
        public void a(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            if (realTimeReliableMessageSentListener != null) {
                realTimeReliableMessageSentListener.onRealTimeMessageSent(this.p, this.ea, this.dZ);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends k.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage dW;

        v(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(au.this, realTimeMessageReceivedListener);
            this.dW = realTimeMessage;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            ax.a("GamesClient", "Deliver Message received callback");
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.dW);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class x
    extends k.b<RoomStatusUpdateListener> {
        private final String dX;

        x(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(au.this, roomStatusUpdateListener);
            this.dX = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.dX);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends k.b<RoomStatusUpdateListener> {
        private final String dX;

        w(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(au.this, roomStatusUpdateListener);
            this.dX = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.dX);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends a {
        aa(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends a {
        y(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends a {
        z(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends a {
        ab(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class ai
    extends c {
        ai(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class al
    extends c {
        al(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomStatusUpdateListener, d2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ak
    extends b {
        ak(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends k.b<RoomUpdateListener> {
        private final int p;
        private final String dV;

        u(RoomUpdateListener roomUpdateListener, int n2, String string2) {
            super(au.this, roomUpdateListener);
            this.p = n2;
            this.dV = string2;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.p, this.dV);
        }

        @Override
        protected void d() {
        }
    }

    final class p
    extends b {
        public p(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class am
    extends b {
        public am(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(roomUpdateListener, d2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> dI;

        a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2, String[] stringArray) {
            super(roomStatusUpdateListener, d2);
            this.dI = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.dI.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.dI);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends k.c<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            super(au.this, roomStatusUpdateListener, d2);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.common.data.d d2) {
            this.a(roomStatusUpdateListener, au.this.x(d2));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends k.c<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            super(au.this, roomUpdateListener, d2);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, com.google.android.gms.common.data.d d2) {
            this.a(roomUpdateListener, au.this.x(d2), d2.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aq
    extends k.b<OnScoreSubmittedListener> {
        private final SubmitScoreResult eh;

        public aq(OnScoreSubmittedListener onScoreSubmittedListener, SubmitScoreResult submitScoreResult) {
            super(au.this, onScoreSubmittedListener);
            this.eh = submitScoreResult;
        }

        @Override
        public void a(OnScoreSubmittedListener onScoreSubmittedListener) {
            onScoreSubmittedListener.onScoreSubmitted(this.eh.getStatusCode(), this.eh);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends k.c<OnPlayersLoadedListener> {
        af(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.common.data.d d2) {
            super(au.this, onPlayersLoadedListener, d2);
        }

        @Override
        protected void a(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.common.data.d d2) {
            onPlayersLoadedListener.onPlayersLoaded(d2.getStatusCode(), new PlayerBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends k.b<OnInvitationReceivedListener> {
        private final Invitation dP;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(au.this, onInvitationReceivedListener);
            this.dP = invitation;
        }

        @Override
        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.dP);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends k.c<OnInvitationsLoadedListener> {
        o(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.common.data.d d2) {
            super(au.this, onInvitationsLoadedListener, d2);
        }

        @Override
        protected void a(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.common.data.d d2) {
            onInvitationsLoadedListener.onInvitationsLoaded(d2.getStatusCode(), new InvitationBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends k.b<OnLeaderboardScoresLoadedListener> {
        private final com.google.android.gms.common.data.d dS;
        private final com.google.android.gms.common.data.d dT;

        r(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener, com.google.android.gms.common.data.d d2, com.google.android.gms.common.data.d d3) {
            super(au.this, onLeaderboardScoresLoadedListener);
            this.dS = d2;
            this.dT = d3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void a(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            com.google.android.gms.common.data.d d2 = this.dS;
            com.google.android.gms.common.data.d d3 = this.dT;
            try {
                if (onLeaderboardScoresLoadedListener != null) {
                    LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(d2);
                    LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(d3);
                    onLeaderboardScoresLoadedListener.onLeaderboardScoresLoaded(d3.getStatusCode(), leaderboardBuffer, leaderboardScoreBuffer);
                    d2 = null;
                    d3 = null;
                }
            }
            finally {
                if (d2 != null) {
                    d2.close();
                }
                if (d3 != null) {
                    d3.close();
                }
            }
        }

        @Override
        protected void d() {
            if (this.dS != null) {
                this.dS.close();
            }
            if (this.dT != null) {
                this.dT.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends k.c<OnLeaderboardMetadataLoadedListener> {
        t(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.common.data.d d2) {
            super(au.this, onLeaderboardMetadataLoadedListener, d2);
        }

        @Override
        protected void a(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.common.data.d d2) {
            onLeaderboardMetadataLoadedListener.onLeaderboardMetadataLoaded(d2.getStatusCode(), new LeaderboardBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends k.c<OnGamesLoadedListener> {
        k(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.common.data.d d2) {
            super(au.this, onGamesLoadedListener, d2);
        }

        @Override
        protected void a(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.common.data.d d2) {
            onGamesLoadedListener.onGamesLoaded(d2.getStatusCode(), new GameBuffer(d2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends k.b<OnAchievementUpdatedListener> {
        private final int p;
        private final String dL;

        e(OnAchievementUpdatedListener onAchievementUpdatedListener, int n2, String string2) {
            super(au.this, onAchievementUpdatedListener);
            this.p = n2;
            this.dL = string2;
        }

        @Override
        protected void a(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            onAchievementUpdatedListener.onAchievementUpdated(this.p, this.dL);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends k.c<OnAchievementsLoadedListener> {
        g(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.common.data.d d2) {
            super(au.this, onAchievementsLoadedListener, d2);
        }

        @Override
        protected void a(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.common.data.d d2) {
            onAchievementsLoadedListener.onAchievementsLoaded(d2.getStatusCode(), new AchievementBuffer(d2));
        }
    }

    final class an
    extends at {
        private final OnSignOutCompleteListener ef;

        public an(OnSignOutCompleteListener onSignOutCompleteListener) {
            this.ef = com.google.android.gms.internal.s.b(onSignOutCompleteListener, (Object)"Listener must not be null");
        }

        public void onSignOutComplete() {
            au.this.a(new ao(this.ef));
        }
    }

    final class ah
    extends at {
        final RealTimeReliableMessageSentListener eb;

        public ah(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            this.eb = realTimeReliableMessageSentListener;
        }

        public void a(int n2, int n3, String string2) {
            au.this.a(new ag(this.eb, n2, n3, string2));
        }
    }

    final class aj
    extends at {
        private final RoomUpdateListener ec;
        private final RoomStatusUpdateListener ed;
        private final RealTimeMessageReceivedListener ee;

        public aj(RoomUpdateListener roomUpdateListener) {
            this.ec = com.google.android.gms.internal.s.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.ed = null;
            this.ee = null;
        }

        public aj(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.ec = com.google.android.gms.internal.s.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.ed = roomStatusUpdateListener;
            this.ee = realTimeMessageReceivedListener;
        }

        public void n(com.google.android.gms.common.data.d d2) {
            au.this.a(new am(this.ec, d2));
        }

        public void o(com.google.android.gms.common.data.d d2) {
            au.this.a(new p(this.ec, d2));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            au.this.a(new u(this.ec, statusCode, externalRoomId));
        }

        public void r(com.google.android.gms.common.data.d d2) {
            au.this.a(new ak(this.ec, d2));
        }

        public void p(com.google.android.gms.common.data.d d2) {
            au.this.a(new al(this.ed, d2));
        }

        public void q(com.google.android.gms.common.data.d d2) {
            au.this.a(new ai(this.ed, d2));
        }

        public void s(com.google.android.gms.common.data.d d2) {
            au.this.a(new h(this.ed, d2));
        }

        public void t(com.google.android.gms.common.data.d d2) {
            au.this.a(new i(this.ed, d2));
        }

        public void e(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new y(this.ed, d2, stringArray));
        }

        public void f(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new aa(this.ed, d2, stringArray));
        }

        public void a(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new ab(this.ed, d2, stringArray));
        }

        public void b(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new ac(this.ed, d2, stringArray));
        }

        public void c(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new ad(this.ed, d2, stringArray));
        }

        public void d(com.google.android.gms.common.data.d d2, String[] stringArray) {
            au.this.a(new z(this.ed, d2, stringArray));
        }

        public void onP2PConnected(String participantId) {
            au.this.a(new w(this.ed, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            au.this.a(new x(this.ed, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            ax.a("GamesClient", "RoomBinderCallbacks: onRealTimeMessageReceived");
            au.this.a(new v(this.ee, message));
        }
    }

    final class ap
    extends at {
        private final OnScoreSubmittedListener eg;

        public ap(OnScoreSubmittedListener onScoreSubmittedListener) {
            this.eg = com.google.android.gms.internal.s.b(onScoreSubmittedListener, (Object)"Listener must not be null");
        }

        public void d(com.google.android.gms.common.data.d d2) {
            SubmitScoreResult submitScoreResult = new SubmitScoreResult(d2);
            au.this.a(new aq(this.eg, submitScoreResult));
        }
    }

    final class ae
    extends at {
        private final OnPlayersLoadedListener dY;

        ae(OnPlayersLoadedListener onPlayersLoadedListener) {
            this.dY = com.google.android.gms.internal.s.b(onPlayersLoadedListener, (Object)"Listener must not be null");
        }

        public void e(com.google.android.gms.common.data.d d2) {
            au.this.a(new af(this.dY, d2));
        }
    }

    final class l
    extends at {
        private final OnInvitationReceivedListener dO;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.dO = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k(com.google.android.gms.common.data.d d2) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(d2);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.close();
            }
            if (invitation != null) {
                au.this.a(new m(this.dO, invitation));
            }
        }
    }

    final class n
    extends at {
        private final OnInvitationsLoadedListener dQ;

        n(OnInvitationsLoadedListener onInvitationsLoadedListener) {
            this.dQ = onInvitationsLoadedListener;
        }

        public void j(com.google.android.gms.common.data.d d2) {
            au.this.a(new o(this.dQ, d2));
        }
    }

    final class q
    extends at {
        private final OnLeaderboardScoresLoadedListener dR;

        q(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            this.dR = com.google.android.gms.internal.s.b(onLeaderboardScoresLoadedListener, (Object)"Listener must not be null");
        }

        public void a(com.google.android.gms.common.data.d d2, com.google.android.gms.common.data.d d3) {
            au.this.a(new r(this.dR, d2, d3));
        }
    }

    final class s
    extends at {
        private final OnLeaderboardMetadataLoadedListener dU;

        s(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener) {
            this.dU = com.google.android.gms.internal.s.b(onLeaderboardMetadataLoadedListener, (Object)"Listener must not be null");
        }

        public void c(com.google.android.gms.common.data.d d2) {
            au.this.a(new t(this.dU, d2));
        }
    }

    final class j
    extends at {
        private final OnGamesLoadedListener dN;

        j(OnGamesLoadedListener onGamesLoadedListener) {
            this.dN = com.google.android.gms.internal.s.b(onGamesLoadedListener, (Object)"Listener must not be null");
        }

        public void g(com.google.android.gms.common.data.d d2) {
            au.this.a(new k(this.dN, d2));
        }
    }

    final class d
    extends at {
        private final OnAchievementUpdatedListener dK;

        d(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            this.dK = com.google.android.gms.internal.s.b(onAchievementUpdatedListener, (Object)"Listener must not be null");
        }

        public void onAchievementUpdated(int statusCode, String achievementId) {
            au.this.a(new e(this.dK, statusCode, achievementId));
        }
    }

    final class f
    extends at {
        private final OnAchievementsLoadedListener dM;

        f(OnAchievementsLoadedListener onAchievementsLoadedListener) {
            this.dM = com.google.android.gms.internal.s.b(onAchievementsLoadedListener, (Object)"Listener must not be null");
        }

        public void b(com.google.android.gms.common.data.d d2) {
            au.this.a(new g(this.dM, d2));
        }
    }
}

