/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.b;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.d;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class c
extends b
implements Room {
    private final int eo;

    c(com.google.android.gms.common.data.d d2, int n2, int n3) {
        super(d2, n2);
        this.eo = n3;
    }

    @Override
    public String getRoomId() {
        return this.getString("external_match_id");
    }

    @Override
    public String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public int getParticipantStatus(String participantId) {
        ArrayList<Participant> arrayList = this.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = arrayList.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.a("description", dataOut);
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n2 = this.getInteger("automatch_min_players");
        int n3 = this.getInteger("automatch_max_players");
        long l2 = this.getLong("automatch_bit_mask");
        return RoomConfig.createAutoMatchCriteria(n2, n3, l2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.eo);
        for (int i2 = 0; i2 < this.eo; ++i2) {
            arrayList.add(new d(this.S, this.V + i2));
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        ArrayList<Participant> arrayList = this.getParticipants();
        ArrayList<String> arrayList2 = new ArrayList<String>(this.eo);
        for (int i2 = 0; i2 < this.eo; ++i2) {
            Participant participant = arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string2 = null;
        ArrayList<Participant> arrayList = this.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.getInteger("automatch_wait_estimate_sec");
    }

    @Override
    public Room freeze() {
        return new RoomEntity(this);
    }

    @Override
    public int hashCode() {
        return RoomEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        RoomEntity roomEntity = (RoomEntity)this.freeze();
        roomEntity.writeToParcel(dest, flags);
    }
}

