/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.b;
import com.google.android.gms.internal.ao;
import com.google.android.gms.internal.av;
import com.google.android.gms.internal.r;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
extends av
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new a();
    private final int ab;
    private final String dV;
    private final String fe;
    private final long eG;
    private final int ff;
    private final String di;
    private final int eK;
    private final Bundle fa;
    private final ArrayList<ParticipantEntity> eJ;
    private final int fg;

    public RoomEntity(Room room) {
        this.ab = 2;
        this.dV = room.getRoomId();
        this.fe = room.getCreatorId();
        this.eG = room.getCreationTimestamp();
        this.ff = room.getStatus();
        this.di = room.getDescription();
        this.eK = room.getVariant();
        this.fa = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.eJ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.eJ.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.fg = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.ab = versionCode;
        this.dV = roomId;
        this.fe = creatorId;
        this.eG = creationTimestamp;
        this.ff = roomStatus;
        this.di = description;
        this.eK = variant;
        this.fa = autoMatchCriteria;
        this.eJ = participants;
        this.fg = autoMatchWaitEstimateSeconds;
    }

    public int i() {
        return this.ab;
    }

    @Override
    public String getRoomId() {
        return this.dV;
    }

    @Override
    public String getCreatorId() {
        return this.fe;
    }

    @Override
    public long getCreationTimestamp() {
        return this.eG;
    }

    @Override
    public int getStatus() {
        return this.ff;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        int n2 = this.eJ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.eJ.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.di;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ao.b(this.di, dataOut);
    }

    @Override
    public int getVariant() {
        return this.eK;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.fa;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.eJ);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        int n2 = this.eJ.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.eJ.get(i2).getParticipantId());
        }
        return arrayList;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string2 = null;
        int n2 = this.eJ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.eJ.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.fg;
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return r.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return r.a(room2.getRoomId(), room.getRoomId()) && r.a(room2.getCreatorId(), room.getCreatorId()) && r.a(room2.getCreationTimestamp(), room.getCreationTimestamp()) && r.a(room2.getStatus(), room.getStatus()) && r.a(room2.getDescription(), room.getDescription()) && r.a(room2.getVariant(), room.getVariant()) && r.a(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && r.a(room2.getParticipants(), room.getParticipants()) && r.a(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return r.c(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.w()) {
            b.a(this, dest, flags);
        } else {
            dest.writeString(this.dV);
            dest.writeString(this.fe);
            dest.writeLong(this.eG);
            dest.writeInt(this.ff);
            dest.writeString(this.di);
            dest.writeInt(this.eK);
            dest.writeBundle(this.fa);
            int n2 = this.eJ.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.eJ.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends b {
        a() {
        }

        public RoomEntity s(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.v());
            if (bl2 || RoomEntity.h(RoomEntity.class.getCanonicalName())) {
                return super.s(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string4 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string2, string3, l2, n3, string4, n4, bundle, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.s(x0);
        }
    }
}

