/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.s;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener eW;
    private final RoomStatusUpdateListener eX;
    private final RealTimeMessageReceivedListener eY;
    private final String eF;
    private final int eK;
    private final String[] eZ;
    private final Bundle fa;
    private final boolean fb;

    private RoomConfig(Builder builder) {
        this.eW = builder.eW;
        this.eX = builder.eX;
        this.eY = builder.eY;
        this.eF = builder.fc;
        this.eK = builder.eK;
        this.fa = builder.fa;
        this.fb = builder.fb;
        int n2 = builder.fd.size();
        this.eZ = builder.fd.toArray(new String[n2]);
        if (this.eY == null) {
            s.a(this.fb, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.eW;
    }

    public String getInvitationId() {
        return this.eF;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.eX;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.eY;
    }

    public int getVariant() {
        return this.eK;
    }

    public String[] getInvitedPlayerIds() {
        return this.eZ;
    }

    public Bundle getAutoMatchCriteria() {
        return this.fa;
    }

    public boolean isSocketEnabled() {
        return this.fb;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener eW;
        RoomStatusUpdateListener eX;
        RealTimeMessageReceivedListener eY;
        String fc = null;
        int eK = -1;
        ArrayList<String> fd = new ArrayList();
        Bundle fa;
        boolean fb = false;

        private Builder(RoomUpdateListener updateListener) {
            this.eW = s.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            s.d(invitationId);
            this.fc = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.eX = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.eY = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            s.d(playerIds);
            this.fd.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            s.d(playerIds);
            this.fd.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            this.eK = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.fb = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.fa = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

