/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.internal.ao;
import com.google.android.gms.internal.av;
import com.google.android.gms.internal.r;

public final class ParticipantEntity
extends av
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int ab;
    private final String dX;
    private final String cl;
    private final Uri dk;
    private final Uri dl;
    private final int eN;
    private final String eO;
    private final boolean eP;
    private final PlayerEntity eQ;
    private final int eR;

    public ParticipantEntity(Participant participant) {
        this.ab = 1;
        this.dX = participant.getParticipantId();
        this.cl = participant.getDisplayName();
        this.dk = participant.getIconImageUri();
        this.dl = participant.getHiResImageUri();
        this.eN = participant.getStatus();
        this.eO = participant.aM();
        this.eP = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.eQ = player == null ? null : new PlayerEntity(player);
        this.eR = participant.aN();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities) {
        this.ab = versionCode;
        this.dX = participantId;
        this.cl = displayName;
        this.dk = iconImageUri;
        this.dl = hiResImageUri;
        this.eN = status;
        this.eO = clientAddress;
        this.eP = connectedToRoom;
        this.eQ = player;
        this.eR = capabilities;
    }

    public int i() {
        return this.ab;
    }

    public int getStatus() {
        return this.eN;
    }

    public String aM() {
        return this.eO;
    }

    public boolean isConnectedToRoom() {
        return this.eP;
    }

    public String getDisplayName() {
        if (this.eQ == null) {
            return this.cl;
        }
        return this.eQ.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.eQ == null) {
            ao.b(this.cl, dataOut);
            return;
        }
        this.eQ.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.eQ == null) {
            return this.dk;
        }
        return this.eQ.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.eQ == null) {
            return this.dl;
        }
        return this.eQ.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.dX;
    }

    public Player getPlayer() {
        return this.eQ;
    }

    public int aN() {
        return this.eR;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return r.hashCode(participant.getPlayer(), participant.getStatus(), participant.aM(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.aN());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return r.a(participant2.getPlayer(), participant.getPlayer()) && r.a(participant2.getStatus(), participant.getStatus()) && r.a(participant2.aM(), participant.aM()) && r.a(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && r.a(participant2.getDisplayName(), participant.getDisplayName()) && r.a(participant2.getIconImageUri(), participant.getIconImageUri()) && r.a(participant2.getHiResImageUri(), participant.getHiResImageUri()) && r.a(participant2.aN(), participant.aN());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return r.c(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.aM()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.aN()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.w()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.dX);
            dest.writeString(this.cl);
            dest.writeString(this.dk == null ? null : this.dk.toString());
            dest.writeString(this.dl == null ? null : this.dl.toString());
            dest.writeInt(this.eN);
            dest.writeString(this.eO);
            dest.writeInt(this.eP ? 1 : 0);
            dest.writeInt(this.eQ == null ? 0 : 1);
            if (this.eQ != null) {
                this.eQ.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends c {
        a() {
        }

        public ParticipantEntity q(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.v());
            if (bl2 || ParticipantEntity.h(ParticipantEntity.class.getCanonicalName())) {
                return super.q(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(1, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.q(x0);
        }
    }
}

