/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.av;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
extends av
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new a();
    private final int ab;
    private final GameEntity eE;
    private final String eF;
    private final long eG;
    private final int eH;
    private final ParticipantEntity eI;
    private final ArrayList<ParticipantEntity> eJ;
    private final int eK;

    InvitationEntity(Invitation invitation) {
        this.ab = 1;
        this.eE = new GameEntity(invitation.getGame());
        this.eF = invitation.getInvitationId();
        this.eG = invitation.getCreationTimestamp();
        this.eH = invitation.aL();
        this.eK = invitation.getVariant();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.eJ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.eJ.add((ParticipantEntity)participant2.freeze());
        }
        s.b(participant, (Object)"Must have a valid inviter!");
        this.eI = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant) {
        this.ab = versionCode;
        this.eE = game;
        this.eF = invitationId;
        this.eG = creationTimestamp;
        this.eH = invitationType;
        this.eI = inviter;
        this.eJ = participants;
        this.eK = variant;
    }

    public int i() {
        return this.ab;
    }

    @Override
    public Game getGame() {
        return this.eE;
    }

    @Override
    public String getInvitationId() {
        return this.eF;
    }

    @Override
    public Participant getInviter() {
        return this.eI;
    }

    @Override
    public long getCreationTimestamp() {
        return this.eG;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.eJ);
    }

    @Override
    public int aL() {
        return this.eH;
    }

    @Override
    public int getVariant() {
        return this.eK;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return r.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.aL(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return r.a(invitation2.getGame(), invitation.getGame()) && r.a(invitation2.getInvitationId(), invitation.getInvitationId()) && r.a(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && r.a(invitation2.aL(), invitation.aL()) && r.a(invitation2.getInviter(), invitation.getInviter()) && r.a(invitation2.getParticipants(), invitation.getParticipants()) && r.a(invitation2.getVariant(), invitation.getVariant());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return r.c(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.aL()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.w()) {
            com.google.android.gms.games.multiplayer.a.a(this, dest, flags);
        } else {
            this.eE.writeToParcel(dest, flags);
            dest.writeString(this.eF);
            dest.writeLong(this.eG);
            dest.writeInt(this.eH);
            this.eI.writeToParcel(dest, flags);
            int n2 = this.eJ.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.eJ.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends com.google.android.gms.games.multiplayer.a {
        a() {
        }

        public InvitationEntity p(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.v());
            if (bl2 || InvitationEntity.h(InvitationEntity.class.getCanonicalName())) {
                return super.p(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new InvitationEntity(1, gameEntity, string2, l2, n3, participantEntity, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.p(x0);
        }
    }
}

