/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.d;
import com.google.android.gms.internal.bd;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubmitScoreResult {
    private static final String[] eB = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest"};
    private String eC;
    private String dx;
    private int p;
    private HashMap<Integer, Result> eD;

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId, HashMap<Integer, Result> results) {
        this.p = statusCode;
        this.eC = leaderboardId;
        this.dx = playerId;
        this.eD = results;
    }

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId) {
        this(statusCode, leaderboardId, playerId, new HashMap<Integer, Result>());
    }

    public SubmitScoreResult(d dataHolder) {
        this.p = dataHolder.getStatusCode();
        this.eD = new HashMap();
        int n2 = dataHolder.getCount();
        s.c(n2 == 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3 = dataHolder.e(i2);
            if (i2 == 0) {
                this.eC = dataHolder.c("leaderboardId", i2, n3);
                this.dx = dataHolder.c("playerId", i2, n3);
            }
            if (!(bl2 = dataHolder.d("hasResult", i2, n3))) continue;
            Result result = new Result(dataHolder.a("rawScore", i2, n3), dataHolder.c("formattedScore", i2, n3), dataHolder.d("newBest", i2, n3));
            this.a(result, dataHolder.b("timeSpan", i2, n3));
        }
    }

    public String getLeaderboardId() {
        return this.eC;
    }

    public String getPlayerId() {
        return this.dx;
    }

    public int getStatusCode() {
        return this.p;
    }

    public Result getScoreResult(int timeSpan) {
        return this.eD.get(timeSpan);
    }

    private void a(Result result, int n2) {
        this.eD.put(n2, result);
    }

    public String toString() {
        r.a a2 = r.c(this).a("PlayerId", this.dx).a("StatusCode", this.p);
        for (int i2 = 0; i2 < 3; ++i2) {
            Result result = this.eD.get(i2);
            a2.a("TimesSpan", bd.G(i2));
            a2.a("Result", result == null ? "null" : result.toString());
        }
        return a2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.newBest = newBest;
        }

        public String toString() {
            return r.c(this).a("RawScore", this.rawScore).a("FormattedScore", this.formattedScore).a("NewBest", this.newBest).toString();
        }
    }
}

