/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.as;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.w;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object aq = new Object();
    private static HashSet<Uri> ar = new HashSet();
    private static ImageManager as;
    private static ImageManager at;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService au;
    private final b av;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> aw;
    private final Map<Uri, ImageReceiver> ax;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (at == null) {
                at = new ImageManager(context, true);
            }
            return at;
        }
        if (as == null) {
            as = new ImageManager(context, false);
        }
        return as;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.au = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.av = new b(this.mContext);
            if (com.google.android.gms.internal.as.aq()) {
                this.n();
            }
        } else {
            this.av = null;
        }
        this.aw = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.ax = new HashMap<Uri, ImageReceiver>();
    }

    private void n() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.av));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, int resId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(resId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.j(defaultResId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(listener);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.j(defaultResId);
        a2.a(listener);
        this.a(a2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        h.f("ImageManager.loadImage() must be called in the main thread");
        boolean bl2 = this.b(a2);
        d d2 = new d(a2);
        if (bl2) {
            d2.run();
        } else {
            this.mHandler.post((Runnable)d2);
        }
    }

    private boolean b(com.google.android.gms.common.images.a a2) {
        h.f("ImageManager.cleanupHashMaps() must be called in the main thread");
        if (a2.aJ == 1) {
            return true;
        }
        ImageReceiver imageReceiver = this.aw.get(a2);
        if (imageReceiver == null) {
            return true;
        }
        if (imageReceiver.az) {
            return false;
        }
        this.aw.remove(a2);
        imageReceiver.d(a2);
        return true;
    }

    private Bitmap a(a.a a2) {
        if (this.av == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.av.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b
    extends w<a.a, Bitmap> {
        public b(Context context) {
            super(b.e(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int e(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && com.google.android.gms.internal.as.an() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b av;

        public e(b b2) {
            this.av = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.av.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.av.evictAll();
            } else if (level >= 20) {
                this.av.trimToSize(this.av.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap aD;
        private final CountDownLatch aE;
        private boolean aF;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.aD = bitmap;
            this.aF = bl2;
            this.aE = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            h.f("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.aD != null;
            if (ImageManager.this.av != null) {
                if (this.aF) {
                    ImageManager.this.av.evictAll();
                    System.gc();
                    this.aF = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.av.put(new a.a(this.mUri), this.aD);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.ax.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.aE.countDown();
            Object object = aq;
            synchronized (object) {
                ar.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            imageReceiver.az = true;
            ArrayList arrayList = imageReceiver.ay;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.aD, false);
                } else {
                    a2.b(ImageManager.this.mContext, false);
                }
                if (a2.aJ == 1) continue;
                ImageManager.this.aw.remove(a2);
            }
            imageReceiver.az = false;
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor aB;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.aB = parcelFileDescriptor;
        }

        public void run() {
            h.g("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.aB != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.aB.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.aB.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> ay;
        boolean az;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.az = false;
            this.mUri = uri;
            this.ay = new ArrayList();
        }

        public void c(com.google.android.gms.common.images.a a2) {
            h.a(!this.az, "Cannot add an ImageRequest when mHandlingRequests is true");
            h.f("ImageReceiver.addImageRequest() must be called in the main thread");
            this.ay.add(a2);
        }

        public void d(com.google.android.gms.common.images.a a2) {
            h.a(!this.az, "Cannot remove an ImageRequest when mHandlingRequests is true");
            h.f("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.ay.remove(a2);
        }

        public void q() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.au.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a aC;

        public d(com.google.android.gms.common.images.a a2) {
            this.aC = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            h.f("LoadImageRunnable must be executed on the main thread");
            ImageManager.this.b(this.aC);
            a.a a2 = this.aC.aG;
            if (a2.uri == null) {
                this.aC.b(ImageManager.this.mContext, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.aC.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.aC.f(ImageManager.this.mContext);
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.ax.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.ax.put(a2.uri, imageReceiver);
            }
            imageReceiver.c(this.aC);
            if (this.aC.aJ != 1) {
                ImageManager.this.aw.put(this.aC, imageReceiver);
            }
            boolean bl2 = false;
            Object object = aq;
            synchronized (object) {
                bl2 = ar.contains(a2.uri);
                if (!bl2) {
                    ar.add(a2.uri);
                    imageReceiver.q();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2);
    }
}

