/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dp;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolylineOptions
implements SafeParcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    private final int W;
    private final List<LatLng> hp;
    private float gY = 10.0f;
    private int K = -16777216;
    private float gT = 0.0f;
    private boolean gU = true;
    private boolean hr = false;

    public PolylineOptions() {
        this.W = 1;
        this.hp = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color2, float zIndex, boolean visible, boolean geodesic) {
        this.W = versionCode;
        this.hp = points;
        this.gY = width;
        this.K = color2;
        this.gT = zIndex;
        this.gU = visible;
        this.hr = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (dh.bm()) {
            dp.a(this, out, flags);
        } else {
            PolylineOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int F() {
        return this.W;
    }

    public PolylineOptions add(LatLng point) {
        this.hp.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.hp.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.hp.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.gY = width;
        return this;
    }

    public PolylineOptions color(int color2) {
        this.K = color2;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.gT = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.gU = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.hr = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.hp;
    }

    public float getWidth() {
        return this.gY;
    }

    public int getColor() {
        return this.K;
    }

    public float getZIndex() {
        return this.gT;
    }

    public boolean isVisible() {
        return this.gU;
    }

    public boolean isGeodesic() {
        return this.hr;
    }
}

