/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.bi;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dk;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int W;
    private BitmapDescriptor gW;
    private LatLng gX;
    private float gY;
    private float gZ;
    private LatLngBounds ha;
    private float gM;
    private float gT;
    private boolean gU = true;
    private float hb = 0.0f;
    private float hc = 0.5f;
    private float hd = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.W = versionCode;
        this.gW = new BitmapDescriptor(bi.a.j(wrappedImage));
        this.gX = location;
        this.gY = width;
        this.gZ = height;
        this.ha = bounds;
        this.gM = bearing;
        this.gT = zIndex;
        this.gU = visible;
        this.hb = transparency;
        this.hc = anchorU;
        this.hd = anchorV;
    }

    public GroundOverlayOptions() {
        this.W = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (dh.bm()) {
            dk.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public IBinder bo() {
        return this.gW.aU().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.gW = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.hc = u2;
        this.hd = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        ac.a(this.ha == null, (Object)"Position has already been set using positionFromBounds");
        ac.b(location != null, "Location must be specified");
        ac.b(width >= 0.0f, "Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        ac.a(this.ha == null, (Object)"Position has already been set using positionFromBounds");
        ac.b(location != null, "Location must be specified");
        ac.b(width >= 0.0f, "Width must be non-negative");
        ac.b(height >= 0.0f, "Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.gX = latLng;
        this.gY = f2;
        this.gZ = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        ac.a(this.gX == null, (Object)("Position has already been set using position: " + this.gX));
        this.ha = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.gM = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.gT = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.gU = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        ac.b(transparency >= 0.0f && transparency <= 1.0f, "Transparency must be in the range [0..1]");
        this.hb = transparency;
        return this;
    }

    public int F() {
        return this.W;
    }

    public BitmapDescriptor getImage() {
        return this.gW;
    }

    public LatLng getLocation() {
        return this.gX;
    }

    public float getWidth() {
        return this.gY;
    }

    public float getHeight() {
        return this.gZ;
    }

    public LatLngBounds getBounds() {
        return this.ha;
    }

    public float getBearing() {
        return this.gM;
    }

    public float getZIndex() {
        return this.gT;
    }

    public float getTransparency() {
        return this.hb;
    }

    public float getAnchorU() {
        return this.hc;
    }

    public float getAnchorV() {
        return this.hd;
    }

    public boolean isVisible() {
        return this.gU;
    }
}

