/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.dh;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int W;
    private Boolean gh;
    private Boolean gi;
    private int gj = -1;
    private CameraPosition gk;
    private Boolean gl;
    private Boolean gm;
    private Boolean gn;
    private Boolean go;
    private Boolean gp;
    private Boolean gq;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.W = versionCode;
        this.gh = cr.a(zOrderOnTop);
        this.gi = cr.a(useViewLifecycleInFragment);
        this.gj = mapType;
        this.gk = camera;
        this.gl = cr.a(zoomControlsEnabled);
        this.gm = cr.a(compassEnabled);
        this.gn = cr.a(scrollGesturesEnabled);
        this.go = cr.a(zoomGesturesEnabled);
        this.gp = cr.a(tiltGesturesEnabled);
        this.gq = cr.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (dh.bm()) {
            cq.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    public int F() {
        return this.W;
    }

    public byte aX() {
        return cr.b(this.gh);
    }

    public byte aY() {
        return cr.b(this.gi);
    }

    public byte aZ() {
        return cr.b(this.gl);
    }

    public byte ba() {
        return cr.b(this.gm);
    }

    public byte bb() {
        return cr.b(this.gn);
    }

    public byte bc() {
        return cr.b(this.go);
    }

    public byte bd() {
        return cr.b(this.gp);
    }

    public byte be() {
        return cr.b(this.gq);
    }

    public GoogleMapOptions() {
        this.W = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.gh = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.gi = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.gj = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.gk = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.gl = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.gm = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.gn = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.go = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.gp = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.gq = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.gh;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.gi;
    }

    public int getMapType() {
        return this.gj;
    }

    public CameraPosition getCamera() {
        return this.gk;
    }

    public Boolean getZoomControlsEnabled() {
        return this.gl;
    }

    public Boolean getCompassEnabled() {
        return this.gm;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.gn;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.go;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.gp;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.gq;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

