/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ab;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    int W;
    int mPriority = 102;
    long fv = 3600000L;
    long fw = (long)((double)this.fv / 6.0);
    boolean fx = false;
    long fq = Long.MAX_VALUE;
    int fy = Integer.MAX_VALUE;
    float fz = 0.0f;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.H(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.c(millis);
        this.fv = millis;
        if (!this.fx) {
            this.fw = (long)((double)this.fv / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.fv;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.c(millis);
        this.fx = true;
        this.fw = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.fw;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.fq = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.fq < 0L) {
            this.fq = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.fq = millis;
        if (this.fq < 0L) {
            this.fq = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.fq;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.fy = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.fy;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.fz = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.fz;
    }

    private static void c(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void H(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String I(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.I(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.fv + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.fw + "ms");
        if (this.fq != Long.MAX_VALUE) {
            long l2 = this.fq - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.fy != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.fy);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ab.hashCode(this.mPriority, this.fv, this.fw, this.fx, this.fq, this.fy, Float.valueOf(this.fz));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.fv == locationRequest.fv && this.fw == locationRequest.fw && this.fx == locationRequest.fx && this.fq == locationRequest.fq && this.fy == locationRequest.fy && this.fz == locationRequest.fz;
    }
}

