/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.l;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.y;
import com.google.android.gms.internal.z;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class u<T extends IInterface>
implements GooglePlayServicesClient {
    private final Context mContext;
    final Handler mHandler;
    private T bn;
    private ArrayList<GooglePlayServicesClient.ConnectionCallbacks> bo;
    final ArrayList<GooglePlayServicesClient.ConnectionCallbacks> bp = new ArrayList();
    private boolean bq = false;
    private ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> br;
    private boolean bs = false;
    private final ArrayList<b<?>> bt = new ArrayList();
    private e bu;
    private final String[] f;
    boolean bv = false;
    boolean bw = false;
    private final Object bx = new Object();
    public static final String[] by = new String[]{"service_esmobile", "service_googleme"};

    protected u(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = ac.d(context);
        this.bo = new ArrayList();
        this.bo.add(ac.d(connectionCallbacks));
        this.br = new ArrayList();
        this.br.add(ac.d(onConnectionFailedListener));
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.f = stringArray;
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String b();

    protected abstract String c();

    protected abstract T c(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.bv = true;
        Object object = this.bx;
        synchronized (object) {
            this.bw = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.bu != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.bn = null;
            v.g(this.mContext).b(this.b(), this.bu);
        }
        this.bu = new e();
        boolean bl2 = v.g(this.mContext).a(this.b(), this.bu);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.b()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.bn != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.bx;
        synchronized (object) {
            return this.bw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.bv = false;
        ArrayList<b<?>> arrayList = this.bx;
        synchronized (arrayList) {
            this.bw = false;
        }
        arrayList = this.bt;
        synchronized (arrayList) {
            int n2 = this.bt.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bt.get(i2).B();
            }
            this.bt.clear();
        }
        this.bn = null;
        if (this.bu != null) {
            v.g(this.mContext).b(this.b(), this.bu);
            this.bu = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] u() {
        return this.f;
    }

    protected final void f(IBinder iBinder) {
        try {
            z z2 = z.a.h(iBinder);
            this.a(z2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(z var1, d var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void v() {
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bo;
        synchronized (arrayList) {
            ac.a(!this.bq);
            this.mHandler.removeMessages(4);
            this.bq = true;
            ac.a(this.bp.size() == 0);
            Bundle bundle = this.w();
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.bo;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.bv && this.isConnected(); ++i2) {
                int n3 = this.bp.size();
                if (this.bp.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnected(bundle);
            }
            this.bp.clear();
            this.bq = false;
        }
    }

    protected Bundle w() {
        return null;
    }

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void x() {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bo;
        synchronized (arrayList) {
            this.bq = true;
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.bo;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.bv; ++i2) {
                if (!this.bo.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onDisconnected();
            }
            this.bq = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.br;
        synchronized (arrayList) {
            this.bs = true;
            ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList2 = this.br;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.bv) {
                    return;
                }
                if (!this.br.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnectionFailed(connectionResult);
            }
            this.bs = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bo;
        synchronized (arrayList) {
            if (this.bo.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                if (this.bq) {
                    this.bo = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.bo);
                }
                this.bo.add(listener);
            }
        }
        if (this.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bo;
        synchronized (arrayList) {
            return this.bo.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.bo;
        synchronized (arrayList) {
            if (this.bo != null) {
                boolean bl2;
                if (this.bq) {
                    this.bo = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.bo);
                }
                if (!(bl2 = this.bo.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
                } else if (this.bq && !this.bp.contains(listener)) {
                    this.bp.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.br;
        synchronized (arrayList) {
            if (this.br.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                if (this.bs) {
                    this.br = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.br);
                }
                this.br.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.br;
        synchronized (arrayList) {
            return this.br.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        ac.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.br;
        synchronized (arrayList) {
            if (this.br != null) {
                boolean bl2;
                if (this.bs) {
                    this.br = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.br);
                }
                if (!(bl2 = this.br.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
                }
            }
        }
    }

    protected final void y() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    protected final T z() {
        this.y();
        return this.bn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.bt;
        synchronized (arrayList) {
            this.bt.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    public static final class d
    extends y.a {
        private u bB;

        public d(u u2) {
            this.bB = u2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            ac.a("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.bB);
            this.bB.a(n2, iBinder, bundle);
            this.bB = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle bC;
        public final IBinder bD;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.bD = iBinder;
            this.bC = bundle;
        }

        @Override
        protected void a(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.bD.getInterfaceDescriptor();
                        if (u.this.c().equals(string2)) {
                            u.this.bn = u.this.c(this.bD);
                            if (u.this.bn != null) {
                                u.this.v();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    v.g(u.this.mContext).b(u.this.b(), u.this.bu);
                    u.this.bu = null;
                    u.this.bn = null;
                    u.this.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.bC != null) {
                        pendingIntent = (PendingIntent)this.bC.getParcelable("pendingIntent");
                    }
                    u.this.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        private final l N;

        public c(TListener TListener, l l2) {
            super(TListener);
            this.N = l2;
        }

        @Override
        protected final void a(TListener TListener) {
            this.a(TListener, this.N);
        }

        protected abstract void a(TListener var1, l var2);

        @Override
        protected void d() {
            if (this.N != null) {
                this.N.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class b<TListener> {
        private TListener mListener;
        private boolean bA;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.bA = false;
        }

        protected abstract void a(TListener var1);

        protected abstract void d();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void A() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.bA) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.a(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.d();
                    throw runtimeException;
                }
            } else {
                this.d();
            }
            b2 = this;
            synchronized (b2) {
                this.bA = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.B();
            ArrayList arrayList = u.this.bt;
            synchronized (arrayList) {
                u.this.bt.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void B() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1 && !u.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.d();
                b2.unregister();
                return;
            }
            Object object = u.this.bx;
            synchronized (object) {
                u.this.bw = false;
            }
            if (msg.what == 3) {
                u.this.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                object = u.this.bo;
                synchronized (object) {
                    if (u.this.bv && u.this.isConnected() && u.this.bo.contains(msg.obj)) {
                        ((GooglePlayServicesClient.ConnectionCallbacks)msg.obj).onConnected(u.this.w());
                    }
                }
                return;
            }
            if (msg.what == 2 && !u.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).d();
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).A();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            u.this.f(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            u.this.bn = null;
            u.this.x();
        }
    }
}

