/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ad;
import com.google.android.gms.internal.ag;
import com.google.android.gms.internal.ef;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.em;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.PlusOneButton;

public class el
extends LinearLayout
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener {
    private static final int iq = Color.parseColor((String)"#666666");
    protected boolean ir;
    protected int is = 0;
    protected final LinearLayout it;
    protected final FrameLayout iu;
    protected final CompoundButton iv;
    private final ProgressBar iw;
    protected final em ix;
    private final ef[] iy = new ef[4];
    protected int aE = 1;
    private int iz = 2;
    private int mSize = 3;
    private Uri[] iA;
    private String[] iB;
    private String[] iC;
    protected String iD;
    protected PlusClient hZ;
    protected eg iE;
    protected final Resources iF;
    protected final LayoutInflater iG;
    private b iH = new b();

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.hZ != null) {
            if (!this.hZ.isConnectionCallbacksRegistered(this)) {
                this.hZ.registerConnectionCallbacks(this);
            }
            if (!this.hZ.isConnectionFailedListenerRegistered(this)) {
                this.hZ.registerConnectionFailedListener(this);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.hZ != null) {
            if (this.hZ.isConnectionCallbacksRegistered(this)) {
                this.hZ.unregisterConnectionCallbacks(this);
            }
            if (this.hZ.isConnectionFailedListenerRegistered(this)) {
                this.hZ.unregisterConnectionFailedListener(this);
            }
        }
    }

    public el(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Context context2;
        ac.a(context, (Object)"Context must not be null.");
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(context) != 0) {
            this.iF = null;
            this.iG = null;
        } else {
            context2 = this.m(context);
            this.iF = context2.getResources();
            this.iG = (LayoutInflater)context2.getSystemService("layout_inflater");
        }
        this.mSize = this.a(context, attributeSet);
        this.iz = this.b(context, attributeSet);
        context2 = new Point();
        this.a((Point)context2);
        if (this.isInEditMode()) {
            TextView textView = new TextView(context);
            textView.setGravity(17);
            textView.setText((CharSequence)"[ +1 ]");
            this.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(context2.x, context2.y));
            this.ix = null;
            this.iw = null;
            this.iv = null;
            this.iu = null;
            this.it = null;
            return;
        }
        this.setFocusable(true);
        this.it = new LinearLayout(context);
        this.it.setGravity(17);
        this.it.setOrientation(0);
        this.addView((View)this.it);
        this.iv = new c(context);
        this.iv.setBackgroundDrawable(null);
        this.ix = this.p(context);
        this.iu = this.n(context);
        this.iu.addView((View)this.iv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        this.b((Point)context2);
        this.iw = this.o(context);
        this.iw.setVisibility(4);
        this.iu.addView((View)this.iw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        int n2 = this.iy.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.iy[i2] = this.q(this.getContext());
        }
        this.bK();
    }

    private int a(Context context, AttributeSet attributeSet) {
        String string2 = ag.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attributeSet, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : ("STANDARD".equalsIgnoreCase(string2) ? 3 : 3)));
    }

    private int b(Context context, AttributeSet attributeSet) {
        String string2 = ag.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attributeSet, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : ("BUBBLE".equalsIgnoreCase(string2) ? 1 : 1));
    }

    private Context m(Context context) {
        try {
            return this.getContext().createPackageContext("com.google.android.gms", 4);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"PlusOneButton", (int)5)) {
                Log.w((String)"PlusOneButton", (String)"Google Play services is not installed");
            }
            return null;
        }
    }

    public void initialize(PlusClient plusClient, String url, int activityRequestCode) {
        ac.a(plusClient, (Object)"Plus client must not be null.");
        ac.a(url, (Object)"URL must not be null.");
        ac.a(activityRequestCode >= 0 && activityRequestCode <= 65535, (Object)"activityRequestCode must be an unsigned 16 bit integer.");
        this.is = activityRequestCode;
        this.iD = url;
        if (plusClient != this.hZ) {
            if (this.hZ != null) {
                this.hZ.unregisterConnectionCallbacks(this);
                this.hZ.unregisterConnectionFailedListener(this);
            }
            this.hZ = plusClient;
            this.hZ.registerConnectionCallbacks(this);
            this.hZ.registerConnectionFailedListener(this);
            int n2 = this.iy.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.iy[i2].a(plusClient);
            }
        } else if (this.hZ.isConnected()) {
            this.onConnected(null);
        }
        this.bG();
    }

    public void onConnected(Bundle connectionHint) {
        if (this.iD != null) {
            this.hZ.a(this.iH, this.iD);
        }
    }

    public void onConnectionFailed(ConnectionResult status) {
        this.bJ();
    }

    public void onDisconnected() {
    }

    public void setOnPlusOneClickListener(PlusOneButton.OnPlusOneClickListener listener) {
        this.setOnClickListener(new a(listener));
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.iv.setOnClickListener(listener);
        this.ix.setOnClickListener(listener);
    }

    public boolean performClick() {
        return this.iv.performClick();
    }

    private void a(Uri[] uriArray) {
        this.iA = uriArray;
        this.bO();
    }

    private void d(String[] stringArray) {
        this.iB = stringArray;
        this.bN();
    }

    private void e(String[] stringArray) {
        this.iC = stringArray;
        this.bN();
    }

    public void setAnnotation(int annotation) {
        ac.a(annotation, (Object)"Annotation must not be null.");
        this.iz = annotation;
        this.bN();
        this.bG();
    }

    private void c(View view) {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        view.setPadding(this.iz == 2 ? n3 : 0, 0, 0, this.mSize == 2 && this.iz == 1 ? n2 : 0);
    }

    private void bF() {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        boolean bl2 = true;
        int n4 = this.iy.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.iy[i2].getVisibility() != 0) continue;
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.iy[i2].getLayoutParams());
            if (bl2) {
                layoutParams.setMargins(n2, 0, n3, 0);
                bl2 = false;
            } else {
                layoutParams.setMargins(n3, 0, n3, 0);
            }
            this.iy[i2].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setSize(int size) {
        this.c(size, this.aE);
    }

    public void setType(int type) {
        this.c(this.mSize, type);
    }

    private void c(int n2, int n3) {
        this.aE = n3;
        this.mSize = n2;
        this.bG();
    }

    protected void bG() {
        if (this.isInEditMode()) {
            return;
        }
        this.it.removeAllViews();
        Point point = new Point();
        this.a(point);
        this.iv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        this.b(point);
        this.iw.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        if (this.iz == 1) {
            this.ix.b(this.bR());
        } else {
            this.ix.b(null);
        }
        this.bO();
        this.ix.setLayoutParams((ViewGroup.LayoutParams)this.bH());
        float f2 = TypedValue.applyDimension((int)2, (float)el.d(this.mSize, this.iz), (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.ix.setTextSize(0, f2);
        this.c((View)this.ix);
        if (this.mSize == 2 && this.iz == 1) {
            this.it.setOrientation(1);
            this.it.addView((View)this.ix);
            this.it.addView((View)this.iu);
        } else {
            this.it.setOrientation(0);
            this.it.addView((View)this.iu);
            int n2 = this.iy.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.it.addView((View)this.iy[i2]);
            }
            this.it.addView((View)this.ix);
        }
        this.requestLayout();
    }

    private FrameLayout n(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setFocusable(false);
        return frameLayout;
    }

    private ProgressBar o(Context context) {
        boolean bl2 = true;
        ProgressBar progressBar = new ProgressBar(context, null, 16843400);
        progressBar.setFocusable(false);
        progressBar.setIndeterminate(true);
        return progressBar;
    }

    private em p(Context context) {
        em em2 = new em(context);
        em2.setFocusable(false);
        em2.setGravity(17);
        em2.setSingleLine();
        float f2 = TypedValue.applyDimension((int)2, (float)el.d(this.mSize, this.iz), (DisplayMetrics)context.getResources().getDisplayMetrics());
        em2.setTextSize(0, f2);
        em2.setTextColor(iq);
        em2.setVisibility(0);
        return em2;
    }

    private ef q(Context context) {
        ef ef2 = new ef(context);
        ef2.setVisibility(8);
        return ef2;
    }

    private static int d(int n2, int n3) {
        switch (n2) {
            case 2: {
                if (n3 == 2) {
                    return 13;
                }
                return 15;
            }
            case 0: {
                return 11;
            }
            case 1: {
                return 13;
            }
        }
        return 13;
    }

    private LinearLayout.LayoutParams bH() {
        LinearLayout.LayoutParams layoutParams;
        switch (this.iz) {
            case 2: {
                layoutParams = new LinearLayout.LayoutParams(-2, -1);
                break;
            }
            case 1: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
                break;
            }
            default: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
            }
        }
        layoutParams.bottomMargin = this.mSize == 2 ? 1 : 0;
        layoutParams.leftMargin = this.mSize == 2 ? 0 : 1;
        return layoutParams;
    }

    public void bI() {
        this.setType(2);
        this.iw.setVisibility(0);
        this.bM();
    }

    public void bJ() {
        this.setType(3);
        this.iw.setVisibility(4);
        this.bM();
    }

    protected void bK() {
        this.setType(1);
        this.iw.setVisibility(4);
        this.bM();
    }

    protected void bL() {
        this.setType(0);
        this.iw.setVisibility(4);
        this.bM();
    }

    protected void bA() {
        if (this.iE == null) {
            return;
        }
        this.d(this.iE.bD());
        this.e(new String[]{this.iE.bC()});
        this.a(this.iE.bE());
        if (this.iE.bB()) {
            this.bL();
        } else {
            this.bK();
        }
    }

    protected void bM() {
        this.iv.setButtonDrawable(this.bP());
        switch (this.aE) {
            case 0: {
                this.iv.setEnabled(true);
                this.iv.setChecked(true);
                break;
            }
            case 1: {
                this.iv.setEnabled(true);
                this.iv.setChecked(false);
                break;
            }
            case 2: {
                this.iv.setEnabled(false);
                this.iv.setChecked(true);
                break;
            }
            default: {
                this.iv.setEnabled(false);
                this.iv.setChecked(false);
            }
        }
    }

    private void bN() {
        switch (this.iz) {
            case 2: {
                this.ix.f(this.iB);
                this.ix.setVisibility(0);
                break;
            }
            case 1: {
                this.ix.f(this.iC);
                this.ix.setVisibility(0);
                break;
            }
            default: {
                this.ix.f(null);
                this.ix.setVisibility(8);
            }
        }
    }

    private void bO() {
        if (this.iA != null && this.iz == 2) {
            Point point = new Point();
            this.a(point);
            point.x = point.y;
            int n2 = this.iy.length;
            int n3 = this.iA.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Uri uri;
                Uri uri2 = uri = i2 < n3 ? this.iA[i2] : null;
                if (uri == null) {
                    this.iy[i2].setVisibility(8);
                    continue;
                }
                this.iy[i2].setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(point.x, point.y));
                this.iy[i2].a(uri, point.y);
                this.iy[i2].setVisibility(0);
            }
        } else {
            int n4 = this.iy.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.iy[i3].setVisibility(8);
            }
        }
        this.bF();
    }

    private void a(Point point) {
        int n2;
        int n3;
        switch (this.mSize) {
            case 1: {
                n3 = 32;
                n2 = 20;
                break;
            }
            case 0: {
                n3 = 24;
                n2 = 14;
                break;
            }
            case 2: {
                n3 = 50;
                n2 = 20;
                break;
            }
            default: {
                n3 = 38;
                n2 = 24;
            }
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f2 = TypedValue.applyDimension((int)1, (float)n3, (DisplayMetrics)displayMetrics);
        float f3 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)displayMetrics);
        point.x = (int)((double)f2 + 0.5);
        point.y = (int)((double)f3 + 0.5);
    }

    private void b(Point point) {
        point.x = point.y = (int)((float)point.y - TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    private Drawable bP() {
        return this.iF == null ? null : this.iF.getDrawable(this.iF.getIdentifier(this.bQ(), "drawable", "com.google.android.gms"));
    }

    private String bQ() {
        switch (this.mSize) {
            case 0: {
                return "ic_plusone_small";
            }
            case 1: {
                return "ic_plusone_medium";
            }
            case 2: {
                return "ic_plusone_tall";
            }
        }
        return "ic_plusone_standard";
    }

    private Uri bR() {
        return ad.l(this.bS());
    }

    private String bS() {
        switch (this.mSize) {
            case 1: {
                return "global_count_bubble_medium";
            }
            case 0: {
                return "global_count_bubble_small";
            }
            case 2: {
                return "global_count_bubble_tall";
            }
        }
        return "global_count_bubble_standard";
    }

    public class b
    implements PlusClient.b {
        protected b() {
        }

        public void a(ConnectionResult connectionResult, eg eg2) {
            if (el.this.ir) {
                el.this.ir = false;
                el.this.iv.refreshDrawableState();
            }
            if (connectionResult.isSuccess() && eg2 != null) {
                el.this.iE = eg2;
                el.this.bA();
                el.this.bG();
            } else {
                el.this.bJ();
            }
        }
    }

    class c
    extends CompoundButton {
        public c(Context context) {
            super(context);
        }

        public void toggle() {
            if (el.this.ir) {
                super.toggle();
            } else {
                el.this.ir = true;
                el.this.bI();
            }
        }
    }

    class a
    implements View.OnClickListener,
    PlusOneButton.OnPlusOneClickListener {
        private final PlusOneButton.OnPlusOneClickListener iI;

        public a(PlusOneButton.OnPlusOneClickListener onPlusOneClickListener) {
            this.iI = onPlusOneClickListener;
        }

        public void onClick(View view) {
            if (view == el.this.iv || view == el.this.ix) {
                Intent intent;
                Intent intent2 = intent = el.this.iE == null ? null : el.this.iE.getIntent();
                if (this.iI != null) {
                    this.iI.onPlusOneClick(intent);
                } else {
                    this.onPlusOneClick(intent);
                }
            }
        }

        public void onPlusOneClick(Intent intent) {
            Context context = el.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, el.this.is);
            }
        }
    }
}

