/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.ck;
import com.google.android.gms.internal.cl;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.z;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cm
extends u<ck> {
    private final cp<ck> fA = new c();
    private final cl fG;
    private final String fH;

    public cm(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string2) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.fG = new cl(context, this.fA);
        this.fH = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        cl cl2 = this.fG;
        synchronized (cl2) {
            if (this.isConnected()) {
                this.fG.removeAllListeners();
                this.fG.aP();
            }
            super.disconnect();
        }
    }

    @Override
    protected String b() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String c() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.y();
        ac.d(callbackIntent);
        ac.b(detectionIntervalMillis >= 0L, "detectionIntervalMillis must be >= 0");
        try {
            ((ck)this.z()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.y();
        ac.d(callbackIntent);
        try {
            ((ck)this.z()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<cn> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.y();
        ac.b(geofences != null && geofences.size() > 0, "At least one geofence must be specified.");
        ac.a(pendingIntent, (Object)"PendingIntent must be specified.");
        ac.a(listener, (Object)"OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener);
            ((ck)this.z()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.y();
        ac.a(pendingIntent, (Object)"PendingIntent must be specified.");
        ac.a(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener);
            ((ck)this.z()).a(pendingIntent, (cj)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.y();
        ac.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, "geofenceRequestIds can't be null nor empty.");
        ac.a(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener);
            ((ck)this.z()).a(stringArray, (cj)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.fG.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        cl cl2 = this.fG;
        synchronized (cl2) {
            this.fG.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.fG.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.fG.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.fG.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.fG.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.fG.setMockLocation(mockLocation);
    }

    protected ck q(IBinder iBinder) {
        return ck.a.p(iBinder);
    }

    @Override
    protected void a(z z2, u.d d2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.fH);
        z2.e(d2, 3225100, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface c(IBinder iBinder) {
        return this.q(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends u.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int p;
        private final String[] fI;
        private final PendingIntent mPendingIntent;
        private final int fM;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(onRemoveGeofencesResultListener);
            r.a(n2 == 2);
            this.fM = n2;
            this.p = LocationStatusCodes.J(n3);
            this.fI = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(onRemoveGeofencesResultListener);
            r.a(n2 == 1);
            this.fM = n2;
            this.p = LocationStatusCodes.J(n3);
            this.mPendingIntent = pendingIntent;
            this.fI = null;
        }

        @Override
        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.fM) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.p, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.p, this.fI);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.fM));
                    }
                }
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class a
    extends u.b<LocationClient.OnAddGeofencesResultListener> {
        private final int p;
        private final String[] fI;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(onAddGeofencesResultListener);
            this.p = LocationStatusCodes.J(n2);
            this.fI = stringArray;
        }

        @Override
        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.p, this.fI);
            }
        }

        @Override
        protected void d() {
        }
    }

    final class b
    extends cj.a {
        private final LocationClient.OnAddGeofencesResultListener fK;
        private final LocationClient.OnRemoveGeofencesResultListener fL;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            this.fK = onAddGeofencesResultListener;
            this.fL = null;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            this.fL = onRemoveGeofencesResultListener;
            this.fK = null;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            cm.this.a(new a(this.fK, statusCode, geofenceRequestIds));
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            cm.this.a(new d(2, this.fL, statusCode, geofenceRequestIds));
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            cm.this.a(new d(1, this.fL, statusCode, pendingIntent));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class c
    implements cp<ck> {
        private c() {
        }

        @Override
        public void y() {
            cm.this.y();
        }

        public ck aQ() {
            return (ck)cm.this.z();
        }

        @Override
        public /* synthetic */ IInterface z() {
            return this.aQ();
        }
    }
}

