/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.ck;
import com.google.android.gms.internal.cp;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cl {
    private final cp<ck> fA;
    private final ContentResolver mContentResolver;
    private ContentProviderClient fB = null;
    private boolean fC = false;
    private HashMap<LocationListener, b> fD = new HashMap();

    public cl(Context context, cp<ck> cp2) {
        this.fA = cp2;
        this.mContentResolver = context.getContentResolver();
    }

    public Location getLastLocation() {
        this.fA.y();
        try {
            return this.fA.z().aO();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.fA.y();
        if (looper == null) {
            ac.a(Looper.myLooper(), (Object)"Can't create handler inside thread that has not called Looper.prepare()");
        }
        HashMap<LocationListener, b> hashMap = this.fD;
        synchronized (hashMap) {
            b b2 = this.fD.get(listener);
            if (b2 == null) {
                b2 = new b(listener, looper);
            }
            this.fD.put(listener, b2);
            try {
                this.fA.z().a(request, b2);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.fA.y();
        try {
            this.fA.z().a(request, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationUpdates(LocationListener listener) {
        this.fA.y();
        ac.a(listener, (Object)"Invalid null listener");
        HashMap<LocationListener, b> hashMap = this.fD;
        synchronized (hashMap) {
            b b2 = this.fD.remove(listener);
            if (this.fB != null && this.fD.isEmpty()) {
                this.fB.release();
                this.fB = null;
            }
            if (b2 != null) {
                b2.release();
                try {
                    this.fA.z().a(b2);
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException(remoteException);
                }
            }
        }
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.fA.y();
        try {
            this.fA.z().a(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void setMockMode(boolean isMockMode) {
        this.fA.y();
        try {
            this.fA.z().setMockMode(isMockMode);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
        this.fC = isMockMode;
    }

    public void setMockLocation(Location mockLocation) {
        this.fA.y();
        try {
            this.fA.z().setMockLocation(mockLocation);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            HashMap<LocationListener, b> hashMap = this.fD;
            synchronized (hashMap) {
                for (b b2 : this.fD.values()) {
                    if (b2 == null) continue;
                    this.fA.z().a(b2);
                }
                this.fD.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void aP() {
        if (this.fC) {
            this.setMockMode(false);
        }
    }

    static class a
    extends Handler {
        private final LocationListener fE;

        public a(LocationListener locationListener) {
            this.fE = locationListener;
        }

        public a(LocationListener locationListener, Looper looper) {
            super(looper);
            this.fE = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.fE.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    static class b
    extends ci.a {
        private Handler fF;

        b(LocationListener locationListener, Looper looper) {
            this.fF = looper == null ? new a(locationListener) : new a(locationListener, looper);
        }

        public void onLocationChanged(Location location) {
            if (this.fF == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.fF.sendMessage(message);
        }

        public void release() {
            this.fF = null;
        }
    }
}

