/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GoogleCloudMessaging {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    static GoogleCloudMessaging fb;
    private Context fc;
    private PendingIntent fd;
    final BlockingQueue<Intent> fe = new LinkedBlockingQueue<Intent>();
    private Handler ff = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Intent intent = (Intent)msg.obj;
            GoogleCloudMessaging.this.fe.add(intent);
        }
    };
    private Messenger fg = new Messenger(this.ff);

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (fb == null) {
            fb = new GoogleCloudMessaging();
            GoogleCloudMessaging.fb.fc = context;
        }
        return fb;
    }

    public void close() {
        this.aN();
    }

    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (to == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.putExtras(data);
        this.c(intent);
        intent.putExtra("google.to", to);
        intent.putExtra("google.message_id", msgId);
        intent.putExtra("google.ttl", Long.toString(timeToLive));
        this.fc.sendOrderedBroadcast(intent, null);
    }

    public void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.aM();
        try {
            Intent intent = this.fe.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string2 = intent.getStringExtra("unregistered");
            if (string2 != null) {
                return;
            }
            String string3 = intent.getStringExtra("error");
            if (string3 != null) {
                throw new IOException(string3);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void b(String ... stringArray) {
        String string2 = this.c(stringArray);
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("google.messenger", (Parcelable)this.fg);
        this.c(intent);
        intent.putExtra("sender", string2);
        this.fc.startService(intent);
    }

    public String register(String ... senderIds) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.fe.clear();
        this.b(senderIds);
        try {
            Intent intent = this.fe.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string2 = intent.getStringExtra("registration_id");
            if (string2 != null) {
                return string2;
            }
            String string3 = intent.getStringExtra("error");
            String string4 = intent.getStringExtra("error");
            if (string4 != null) {
                throw new IOException(string4);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void aM() {
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage("com.google.android.gms");
        this.fe.clear();
        intent.putExtra("google.messenger", (Parcelable)this.fg);
        this.c(intent);
        this.fc.startService(intent);
    }

    String c(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append(',').append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            return null;
        }
        String string3 = intent.getStringExtra("message_type");
        if (string3 != null) {
            return string3;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void c(Intent intent) {
        if (this.fd == null) {
            this.fd = PendingIntent.getBroadcast((Context)this.fc, (int)0, (Intent)new Intent(), (int)0);
        }
        intent.putExtra("app", (Parcelable)this.fd);
    }

    synchronized void aN() {
        if (this.fd != null) {
            this.fd.cancel();
            this.fd = null;
        }
    }
}

