/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.bq;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
extends bq
implements Invitation {
    public static final InvitationEntityCreator CREATOR = new a();
    private final int W;
    private final GameEntity ez;
    private final String eA;
    private final long eB;
    private final int eC;
    private final ParticipantEntity eD;
    private final ArrayList<ParticipantEntity> eE;
    private final int eF;

    public InvitationEntity(Invitation invitation) {
        this.W = 1;
        this.ez = new GameEntity(invitation.getGame());
        this.eA = invitation.getInvitationId();
        this.eB = invitation.getCreationTimestamp();
        this.eC = invitation.aJ();
        this.eF = invitation.getVariant();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.eE = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.eE.add((ParticipantEntity)participant2.freeze());
        }
        ac.a(participant, (Object)"Must have a valid inviter!");
        this.eD = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant) {
        this.W = versionCode;
        this.ez = game;
        this.eA = invitationId;
        this.eB = creationTimestamp;
        this.eC = invitationType;
        this.eD = inviter;
        this.eE = participants;
        this.eF = variant;
    }

    public int F() {
        return this.W;
    }

    @Override
    public Game getGame() {
        return this.ez;
    }

    @Override
    public String getInvitationId() {
        return this.eA;
    }

    @Override
    public Participant getInviter() {
        return this.eD;
    }

    @Override
    public long getCreationTimestamp() {
        return this.eB;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.eE);
    }

    @Override
    public int aJ() {
        return this.eC;
    }

    @Override
    public int getVariant() {
        return this.eF;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    public static int a(Invitation invitation) {
        return ab.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.aJ(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    public static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return ab.equal(invitation2.getGame(), invitation.getGame()) && ab.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && ab.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && ab.equal(invitation2.aJ(), invitation.aJ()) && ab.equal(invitation2.getInviter(), invitation.getInviter()) && ab.equal(invitation2.getParticipants(), invitation.getParticipants()) && ab.equal(invitation2.getVariant(), invitation.getVariant());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    public static String b(Invitation invitation) {
        return ab.c(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.aJ()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.t()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.ez.writeToParcel(dest, flags);
            dest.writeString(this.eA);
            dest.writeLong(this.eB);
            dest.writeInt(this.eC);
            this.eD.writeToParcel(dest, flags);
            int n2 = this.eE.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.eE.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends InvitationEntityCreator {
        a() {
        }

        public InvitationEntity createFromParcel(Parcel in) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.s());
            if (bl2 || InvitationEntity.g(InvitationEntity.class.getCanonicalName())) {
                return super.createFromParcel(in);
            }
            GameEntity gameEntity = GameEntity.CREATOR.createFromParcel(in);
            String string2 = in.readString();
            long l2 = in.readLong();
            int n3 = in.readInt();
            ParticipantEntity participantEntity = ParticipantEntity.CREATOR.createFromParcel(in);
            int n4 = in.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(in));
            }
            n2 = -1;
            return new InvitationEntity(1, gameEntity, string2, l2, n3, participantEntity, arrayList, n2);
        }
    }
}

