/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.internal.aj;
import com.google.android.gms.internal.bg;
import com.google.android.gms.internal.o;
import com.google.android.gms.internal.r;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object al = new Object();
    private static HashSet<Uri> am = new HashSet();
    private static ImageManager an;
    private static ImageManager ao;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService ap;
    private final b aq;
    private final Map<o, c> ar;
    private final Map<Uri, c> as;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (ao == null) {
                ao = new ImageManager(context, true);
            }
            return ao;
        }
        if (an == null) {
            an = new ImageManager(context, false);
        }
        return an;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.ap = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.aq = new b(this.mContext);
            if (bg.ao()) {
                this.k();
            }
        } else {
            this.aq = null;
        }
        this.ar = new HashMap<o, c>();
        this.as = new HashMap<Uri, c>();
    }

    private void k() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new f(this.aq));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        o o2 = new o(uri);
        o2.a(imageView);
        this.a(o2);
    }

    public void loadImage(ImageView imageView, int resId) {
        o o2 = new o(resId);
        o2.a(imageView);
        this.a(o2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        o o2 = new o(uri);
        o2.j(defaultResId);
        o2.a(imageView);
        this.a(o2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        o o2 = new o(uri);
        o2.a(listener);
        this.a(o2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        o o2 = new o(uri);
        o2.j(defaultResId);
        o2.a(listener);
        this.a(o2);
    }

    public void a(o o2) {
        r.e("ImageManager.loadImage() must be called in the main thread");
        boolean bl2 = this.b(o2);
        e e2 = new e(o2);
        if (bl2) {
            e2.run();
        } else {
            this.mHandler.post((Runnable)e2);
        }
    }

    private boolean b(o o2) {
        r.e("ImageManager.cleanupHashMaps() must be called in the main thread");
        if (o2.aE == 1) {
            return true;
        }
        c c2 = this.ar.get(o2);
        if (c2 == null) {
            return true;
        }
        if (c2.au) {
            return false;
        }
        this.ar.remove(o2);
        c2.d(o2);
        return true;
    }

    private Bitmap a(o.a a2) {
        if (this.aq == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.aq.get(a2);
        return bitmap;
    }

    static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class b
    extends aj<o.a, Bitmap> {
        public b(Context context) {
            super(b.e(context));
        }

        protected void a(boolean bl2, o.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int e(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && bg.al() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(o.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((o.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (o.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    static final class f
    implements ComponentCallbacks2 {
        private final b aq;

        public f(b b2) {
            this.aq = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.aq.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.aq.evictAll();
            } else if (level >= 20) {
                this.aq.trimToSize(this.aq.size() / 2);
            }
        }
    }

    final class g
    implements Runnable {
        private final Uri mUri;
        private final Bitmap ay;
        private final CountDownLatch az;
        private boolean aA;

        public g(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.ay = bitmap;
            this.aA = bl2;
            this.az = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            c c2;
            boolean bl2;
            r.e("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.ay != null;
            if (ImageManager.this.aq != null) {
                if (this.aA) {
                    ImageManager.this.aq.evictAll();
                    System.gc();
                    this.aA = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.aq.put(new o.a(this.mUri), this.ay);
                }
            }
            if ((c2 = (c)((Object)ImageManager.this.as.remove(this.mUri))) != null) {
                this.a(c2, bl2);
            }
            this.az.countDown();
            Object object = al;
            synchronized (object) {
                am.remove(this.mUri);
            }
        }

        private void a(c c2, boolean bl2) {
            c2.au = true;
            ArrayList arrayList = c2.at;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                o o2 = (o)arrayList.get(i2);
                if (bl2) {
                    o2.a(ImageManager.this.mContext, this.ay, false);
                } else {
                    o2.b(ImageManager.this.mContext, false);
                }
                if (o2.aE == 1) continue;
                ImageManager.this.ar.remove(o2);
            }
            c2.au = false;
        }
    }

    final class d
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor aw;

        public d(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.aw = parcelFileDescriptor;
        }

        public void run() {
            r.f("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.aw != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.aw.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.aw.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new g(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    final class c
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<o> at;
        boolean au;

        c(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.au = false;
            this.mUri = uri;
            this.at = new ArrayList();
        }

        public void c(o o2) {
            r.a(!this.au, "Cannot add an ImageRequest when mHandlingRequests is true");
            r.e("ImageReceiver.addImageRequest() must be called in the main thread");
            this.at.add(o2);
        }

        public void d(o o2) {
            r.a(!this.au, "Cannot remove an ImageRequest when mHandlingRequests is true");
            r.e("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.at.remove(o2);
        }

        public void n() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.ap.execute(new d(this.mUri, parcelFileDescriptor));
        }
    }

    final class e
    implements Runnable {
        private final o ax;

        public e(o o2) {
            this.ax = o2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            r.e("LoadImageRunnable must be executed on the main thread");
            ImageManager.this.b(this.ax);
            o.a a2 = this.ax.aB;
            if (a2.uri == null) {
                this.ax.b(ImageManager.this.mContext, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.ax.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.ax.f(ImageManager.this.mContext);
            c c2 = (c)((Object)ImageManager.this.as.get(a2.uri));
            if (c2 == null) {
                c2 = new c(a2.uri);
                ImageManager.this.as.put(a2.uri, c2);
            }
            c2.c(this.ax);
            if (this.ax.aE != 1) {
                ImageManager.this.ar.put(this.ax, c2);
            }
            boolean bl2 = false;
            Object object = al;
            synchronized (object) {
                bl2 = am.contains(a2.uri);
                if (!bl2) {
                    am.add(a2.uri);
                    c2.n();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2);
    }
}

