/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.af;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int K;
    private View L;
    private View.OnClickListener M = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.K);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        ac.a(buttonSize >= 0 && buttonSize < 3, (Object)("Unknown button size " + buttonSize));
        ac.a(colorScheme >= 0 && colorScheme < 2, (Object)("Unknown color scheme " + colorScheme));
        this.mSize = buttonSize;
        this.K = colorScheme;
        this.d(this.getContext());
    }

    private void d(Context context) {
        if (this.L != null) {
            this.removeView(this.L);
        }
        try {
            this.L = ae.d(context, this.mSize, this.K);
        }
        catch (ae.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.L = SignInButton.c(context, this.mSize, this.K);
        }
        this.addView(this.L);
        this.L.setEnabled(this.isEnabled());
        this.L.setOnClickListener((View.OnClickListener)this);
    }

    private static Button c(Context context, int n2, int n3) {
        af af2 = new af(context);
        af2.a(context.getResources(), n2, n3);
        return af2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.M = listener;
        if (this.L != null) {
            this.L.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.L.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.M != null && view == this.L) {
            this.M.onClick((View)this);
        }
    }
}

