/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import com.google.android.gms.appstate.OnSignOutCompleteListener;
import com.google.android.gms.appstate.OnStateDeletedListener;
import com.google.android.gms.appstate.OnStateListLoadedListener;
import com.google.android.gms.appstate.OnStateLoadedListener;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.e;

public final class AppStateClient
implements GooglePlayServicesClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_CLIENT_RECONNECT_REQUIRED = 2;
    public static final int STATUS_NETWORK_ERROR_STALE_DATA = 3;
    public static final int STATUS_NETWORK_ERROR_NO_DATA = 4;
    public static final int STATUS_NETWORK_ERROR_OPERATION_DEFERRED = 5;
    public static final int STATUS_NETWORK_ERROR_OPERATION_FAILED = 6;
    public static final int STATUS_DEVELOPER_ERROR = 7;
    public static final int STATUS_WRITE_OUT_OF_DATE_VERSION = 2000;
    public static final int STATUS_WRITE_SIZE_EXCEEDED = 2001;
    public static final int STATUS_STATE_KEY_NOT_FOUND = 2002;
    public static final int STATUS_STATE_KEY_LIMIT_EXCEEDED = 2003;
    private final e b;

    private AppStateClient(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener, String accountName, String[] scopes) {
        this.b = new e(context, connectedListener, connectionFailedListener, accountName, scopes);
    }

    public void connect() {
        this.b.connect();
    }

    public boolean isConnected() {
        return this.b.isConnected();
    }

    public boolean isConnecting() {
        return this.b.isConnecting();
    }

    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.b.registerConnectionCallbacks(listener);
    }

    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.b.isConnectionCallbacksRegistered(listener);
    }

    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.b.unregisterConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.b.registerConnectionFailedListener(listener);
    }

    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.b.isConnectionFailedListenerRegistered(listener);
    }

    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.b.unregisterConnectionFailedListener(listener);
    }

    public void disconnect() {
        this.b.disconnect();
    }

    public void reconnect() {
        this.b.disconnect();
        this.b.connect();
    }

    public int getMaxStateSize() {
        return this.b.getMaxStateSize();
    }

    public int getMaxNumKeys() {
        return this.b.getMaxNumKeys();
    }

    public void updateState(int stateKey, byte[] data) {
        this.b.a(null, stateKey, data);
    }

    public void updateStateImmediate(OnStateLoadedListener listener, int stateKey, byte[] data) {
        ac.a(listener, (Object)"Must provide a valid listener");
        this.b.a(listener, stateKey, data);
    }

    public void deleteState(OnStateDeletedListener listener, int stateKey) {
        this.b.deleteState(listener, stateKey);
    }

    public void loadState(OnStateLoadedListener listener, int stateKey) {
        this.b.loadState(listener, stateKey);
    }

    public void listStates(OnStateListLoadedListener listener) {
        this.b.listStates(listener);
    }

    public void resolveState(OnStateLoadedListener listener, int stateKey, String resolvedVersion, byte[] resolvedData) {
        this.b.resolveState(listener, stateKey, resolvedVersion, resolvedData);
    }

    public void signOut() {
        this.b.signOut(null);
    }

    public void signOut(OnSignOutCompleteListener listener) {
        ac.a(listener, (Object)"Must provide a valid listener");
        this.b.signOut(listener);
    }

    public static final class Builder {
        private static final String[] c = new String[]{"https://www.googleapis.com/auth/appstate"};
        private Context mContext;
        private GooglePlayServicesClient.ConnectionCallbacks d;
        private GooglePlayServicesClient.OnConnectionFailedListener e;
        private String[] f;
        private String g;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.d = connectedListener;
            this.e = connectionFailedListener;
            this.f = c;
            this.g = "<<default account>>";
        }

        public Builder setScopes(String ... scopes) {
            this.f = scopes;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.g = ac.d(accountName);
            return this;
        }

        public AppStateClient create() {
            return new AppStateClient(this.mContext, this.d, this.e, this.g, this.f);
        }
    }
}

