/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.de;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements ae {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int T;
    private final List<LatLng> gu;
    private final List<List<LatLng>> gv;
    private float fV = 10.0f;
    private int fW = -16777216;
    private int fX = 0;
    private float fY = 0.0f;
    private boolean fZ = true;
    private boolean gw = false;

    public PolygonOptions() {
        this.T = 1;
        this.gu = new ArrayList<LatLng>();
        this.gv = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.T = versionCode;
        this.gu = points;
        this.gv = holes;
        this.fV = strokeWidth;
        this.fW = strokeColor;
        this.fX = fillColor;
        this.fY = zIndex;
        this.fZ = visible;
        this.gw = geodesic;
    }

    public int u() {
        return this.T;
    }

    public List ba() {
        return this.gv;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aW()) {
            de.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.gu.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.gu.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.gu.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.gv.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.fV = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.fW = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.fX = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.fY = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.fZ = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.gw = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.gu;
    }

    public List<List<LatLng>> getHoles() {
        return this.gv;
    }

    public float getStrokeWidth() {
        return this.fV;
    }

    public int getStrokeColor() {
        return this.fW;
    }

    public int getFillColor() {
        return this.fX;
    }

    public float getZIndex() {
        return this.fY;
    }

    public boolean isVisible() {
        return this.fZ;
    }

    public boolean isGeodesic() {
        return this.gw;
    }
}

