/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.x;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBoundsCreator;

public final class LatLngBounds
implements ae {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int T;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        x.b(southwest, (Object)"null southwest");
        x.b(northeast, (Object)"null northeast");
        x.a(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.T = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    public int u() {
        return this.T;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aW()) {
            db.a(this, out, flags);
        } else {
            LatLngBoundsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return w.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return w.c(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double gj = Double.POSITIVE_INFINITY;
        private double gk = Double.NEGATIVE_INFINITY;
        private double gl = Double.NaN;
        private double gm = Double.NaN;

        public Builder include(LatLng point) {
            this.gj = Math.min(this.gj, point.latitude);
            this.gk = Math.max(this.gk, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.gl)) {
                this.gl = d2;
                this.gm = d2;
            } else if (!this.b(d2)) {
                if (LatLngBounds.b(this.gl, d2) < LatLngBounds.c(this.gm, d2)) {
                    this.gl = d2;
                } else {
                    this.gm = d2;
                }
            }
            return this;
        }

        private boolean b(double d2) {
            if (this.gl <= this.gm) {
                return this.gl <= d2 && d2 <= this.gm;
            }
            return this.gl <= d2 || d2 <= this.gm;
        }

        public LatLngBounds build() {
            x.a(!Double.isNaN(this.gl), "no included points");
            return new LatLngBounds(new LatLng(this.gj, this.gl), new LatLng(this.gk, this.gm));
        }
    }
}

