/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.bc;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.x;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GroundOverlayOptions
implements ae {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int T;
    private BitmapDescriptor gb;
    private LatLng gc;
    private float gd;
    private float ge;
    private LatLngBounds gf;
    private float fR;
    private float fY;
    private boolean fZ = true;
    private float gg = 0.0f;
    private float gh = 0.5f;
    private float gi = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.T = versionCode;
        this.gb = new BitmapDescriptor(bc.a.j(wrappedImage));
        this.gc = location;
        this.gd = width;
        this.ge = height;
        this.gf = bounds;
        this.fR = bearing;
        this.fY = zIndex;
        this.fZ = visible;
        this.gg = transparency;
        this.gh = anchorU;
        this.gi = anchorV;
    }

    public GroundOverlayOptions() {
        this.T = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aW()) {
            da.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public IBinder aY() {
        return this.gb.aE().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.gb = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.gh = u2;
        this.gi = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        x.a(this.gf == null, "Position has already been set using positionFromBounds");
        x.b(location != null, (Object)"Location must be specified");
        x.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        x.a(this.gf == null, "Position has already been set using positionFromBounds");
        x.b(location != null, (Object)"Location must be specified");
        x.b(width >= 0.0f, (Object)"Width must be non-negative");
        x.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.gc = latLng;
        this.gd = f2;
        this.ge = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        x.a(this.gc == null, "Position has already been set using position: " + this.gc);
        this.gf = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.fR = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.fY = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.fZ = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        x.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.gg = transparency;
        return this;
    }

    public int u() {
        return this.T;
    }

    public BitmapDescriptor getImage() {
        return this.gb;
    }

    public LatLng getLocation() {
        return this.gc;
    }

    public float getWidth() {
        return this.gd;
    }

    public float getHeight() {
        return this.ge;
    }

    public LatLngBounds getBounds() {
        return this.gf;
    }

    public float getBearing() {
        return this.fR;
    }

    public float getZIndex() {
        return this.fY;
    }

    public float getTransparency() {
        return this.gg;
    }

    public float getAnchorU() {
        return this.gh;
    }

    public float getAnchorV() {
        return this.gi;
    }

    public boolean isVisible() {
        return this.fZ;
    }
}

