/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.internal.bc;
import com.google.android.gms.internal.ck;
import com.google.android.gms.internal.cm;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cu;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.dn;
import com.google.android.gms.internal.do;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.internal.IUiSettingsDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;

public interface IGoogleMapDelegate
extends IInterface {
    public CameraPosition getCameraPosition() throws RemoteException;

    public float getMaxZoomLevel() throws RemoteException;

    public float getMinZoomLevel() throws RemoteException;

    public void moveCamera(bc var1) throws RemoteException;

    public void animateCamera(bc var1) throws RemoteException;

    public void animateCameraWithCallback(bc var1, ck var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback(bc var1, int var2, ck var3) throws RemoteException;

    public void stopAnimation() throws RemoteException;

    public IPolylineDelegate addPolyline(PolylineOptions var1) throws RemoteException;

    public dn addPolygon(PolygonOptions var1) throws RemoteException;

    public dm addMarker(MarkerOptions var1) throws RemoteException;

    public dl addGroundOverlay(GroundOverlayOptions var1) throws RemoteException;

    public do addTileOverlay(TileOverlayOptions var1) throws RemoteException;

    public void clear() throws RemoteException;

    public int getMapType() throws RemoteException;

    public void setMapType(int var1) throws RemoteException;

    public boolean isTrafficEnabled() throws RemoteException;

    public void setTrafficEnabled(boolean var1) throws RemoteException;

    public boolean isIndoorEnabled() throws RemoteException;

    public boolean setIndoorEnabled(boolean var1) throws RemoteException;

    public boolean isMyLocationEnabled() throws RemoteException;

    public void setMyLocationEnabled(boolean var1) throws RemoteException;

    public Location getMyLocation() throws RemoteException;

    public void setLocationSource(ILocationSourceDelegate var1) throws RemoteException;

    public IUiSettingsDelegate getUiSettings() throws RemoteException;

    public IProjectionDelegate getProjection() throws RemoteException;

    public void setOnCameraChangeListener(cn var1) throws RemoteException;

    public void setOnMapClickListener(cq var1) throws RemoteException;

    public void setOnMapLongClickListener(cr var1) throws RemoteException;

    public void setOnMarkerClickListener(cs var1) throws RemoteException;

    public void setOnMarkerDragListener(ct var1) throws RemoteException;

    public void setOnInfoWindowClickListener(co var1) throws RemoteException;

    public void setInfoWindowAdapter(cm var1) throws RemoteException;

    public bc getTestingHelper() throws RemoteException;

    public dk addCircle(CircleOptions var1) throws RemoteException;

    public void setOnMyLocationChangeListener(cu var1) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IGoogleMapDelegate$a
    extends Binder
    implements IGoogleMapDelegate {
        public static IGoogleMapDelegate u(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
            if (iInterface != null && iInterface instanceof IGoogleMapDelegate) {
                return (IGoogleMapDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraPosition cameraPosition = this.getCameraPosition();
                    reply.writeNoException();
                    if (cameraPosition != null) {
                        reply.writeInt(1);
                        cameraPosition.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f2 = this.getMaxZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f2);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f3 = this.getMinZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f3);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    bc bc2 = bc.a.j(data.readStrongBinder());
                    this.moveCamera(bc2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    bc bc3 = bc.a.j(data.readStrongBinder());
                    this.animateCamera(bc3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    bc bc4 = bc.a.j(data.readStrongBinder());
                    ck ck2 = ck.a.s(data.readStrongBinder());
                    this.animateCameraWithCallback(bc4, ck2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    bc bc5 = bc.a.j(data.readStrongBinder());
                    int n2 = data.readInt();
                    ck ck3 = ck.a.s(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback(bc5, n2, ck3);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.stopAnimation();
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolylineOptions polylineOptions = 0 != data.readInt() ? PolylineOptions.CREATOR.createFromParcel(data) : null;
                    IPolylineDelegate iPolylineDelegate = this.addPolyline(polylineOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(iPolylineDelegate != null ? iPolylineDelegate.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolygonOptions polygonOptions = 0 != data.readInt() ? PolygonOptions.CREATOR.createFromParcel(data) : null;
                    dn dn2 = this.addPolygon(polygonOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(dn2 != null ? dn2.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.createFromParcel(data) : null;
                    dm dm2 = this.addMarker(markerOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(dm2 != null ? dm2.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.createFromParcel(data) : null;
                    dl dl2 = this.addGroundOverlay(groundOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(dl2 != null ? dl2.asBinder() : null);
                    return true;
                }
                case 13: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    TileOverlayOptions tileOverlayOptions = 0 != data.readInt() ? TileOverlayOptions.CREATOR.createFromParcel(data) : null;
                    do do_ = this.addTileOverlay(tileOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(do_ != null ? do_.asBinder() : null);
                    return true;
                }
                case 14: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.clear();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n3 = this.getMapType();
                    reply.writeNoException();
                    reply.writeInt(n3);
                    return true;
                }
                case 16: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n4 = data.readInt();
                    this.setMapType(n4);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl2 = this.isTrafficEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl3 = 0 != data.readInt();
                    this.setTrafficEnabled(bl3);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl4 = this.isIndoorEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl4 ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl5 = 0 != data.readInt();
                    boolean bl6 = this.setIndoorEnabled(bl5);
                    reply.writeNoException();
                    reply.writeInt(bl6 ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl7 = this.isMyLocationEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl7 ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl8 = 0 != data.readInt();
                    this.setMyLocationEnabled(bl8);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Location location = this.getMyLocation();
                    reply.writeNoException();
                    if (location != null) {
                        reply.writeInt(1);
                        location.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ILocationSourceDelegate iLocationSourceDelegate = ILocationSourceDelegate.a.w(data.readStrongBinder());
                    this.setLocationSource(iLocationSourceDelegate);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IUiSettingsDelegate iUiSettingsDelegate = this.getUiSettings();
                    reply.writeNoException();
                    reply.writeStrongBinder(iUiSettingsDelegate != null ? iUiSettingsDelegate.asBinder() : null);
                    return true;
                }
                case 26: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IProjectionDelegate iProjectionDelegate = this.getProjection();
                    reply.writeNoException();
                    reply.writeStrongBinder(iProjectionDelegate != null ? iProjectionDelegate.asBinder() : null);
                    return true;
                }
                case 27: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cn cn2 = cn.a.z(data.readStrongBinder());
                    this.setOnCameraChangeListener(cn2);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cq cq2 = cq.a.C(data.readStrongBinder());
                    this.setOnMapClickListener(cq2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cr cr2 = cr.a.D(data.readStrongBinder());
                    this.setOnMapLongClickListener(cr2);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cs cs2 = cs.a.E(data.readStrongBinder());
                    this.setOnMarkerClickListener(cs2);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ct ct2 = ct.a.F(data.readStrongBinder());
                    this.setOnMarkerDragListener(ct2);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    co co2 = co.a.A(data.readStrongBinder());
                    this.setOnInfoWindowClickListener(co2);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cm cm2 = cm.a.v(data.readStrongBinder());
                    this.setInfoWindowAdapter(cm2);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    bc bc6 = this.getTestingHelper();
                    reply.writeNoException();
                    reply.writeStrongBinder(bc6 != null ? bc6.asBinder() : null);
                    return true;
                }
                case 35: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CircleOptions circleOptions = 0 != data.readInt() ? CircleOptions.CREATOR.createFromParcel(data) : null;
                    dk dk2 = this.addCircle(circleOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(dk2 != null ? dk2.asBinder() : null);
                    return true;
                }
                case 36: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    cu cu2 = cu.a.G(data.readStrongBinder());
                    this.setOnMyLocationChangeListener(cu2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        static class a
        implements IGoogleMapDelegate {
            private IBinder a;

            a(IBinder iBinder) {
                this.a = iBinder;
            }

            public IBinder asBinder() {
                return this.a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CameraPosition getCameraPosition() throws RemoteException {
                CameraPosition cameraPosition;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    cameraPosition = 0 != parcel2.readInt() ? CameraPosition.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return cameraPosition;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public float getMaxZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public float getMinZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moveCamera(bc update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.a.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void animateCamera(bc update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.a.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void animateCameraWithCallback(bc update, ck callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.a.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void animateCameraWithDurationAndCallback(bc update, int durationMs, ck callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.a.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stopAnimation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IPolylineDelegate addPolyline(PolylineOptions options) throws RemoteException {
                IPolylineDelegate iPolylineDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iPolylineDelegate = IPolylineDelegate.a.O(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPolylineDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public dn addPolygon(PolygonOptions options) throws RemoteException {
                dn dn2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    dn2 = dn.a.N(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return dn2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public dm addMarker(MarkerOptions options) throws RemoteException {
                dm dm2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    dm2 = dm.a.M(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return dm2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public dl addGroundOverlay(GroundOverlayOptions options) throws RemoteException {
                dl dl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    dl2 = dl.a.L(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return dl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public do addTileOverlay(TileOverlayOptions options) throws RemoteException {
                do do_;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    do_ = do.a.P(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return do_;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getMapType() throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setMapType(int type) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(type);
                    this.a.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isTrafficEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setTrafficEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.a.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isIndoorEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setIndoorEnabled(boolean enabled) throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.a.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isMyLocationEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setMyLocationEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.a.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Location getMyLocation() throws RemoteException {
                Location location;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    location = 0 != parcel2.readInt() ? (Location)Location.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return location;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setLocationSource(ILocationSourceDelegate source) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(source != null ? source.asBinder() : null);
                    this.a.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IUiSettingsDelegate getUiSettings() throws RemoteException {
                IUiSettingsDelegate iUiSettingsDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    iUiSettingsDelegate = IUiSettingsDelegate.a.I(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iUiSettingsDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IProjectionDelegate getProjection() throws RemoteException {
                IProjectionDelegate iProjectionDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    iProjectionDelegate = IProjectionDelegate.a.H(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iProjectionDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnCameraChangeListener(cn listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnMapClickListener(cq listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnMapLongClickListener(cr listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnMarkerClickListener(cs listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnMarkerDragListener(ct listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnInfoWindowClickListener(co listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setInfoWindowAdapter(cm adapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.a.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bc getTestingHelper() throws RemoteException {
                bc bc2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.a.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    bc2 = bc.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bc2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public dk addCircle(CircleOptions options) throws RemoteException {
                dk dk2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    dk2 = dk.a.K(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return dk2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnMyLocationChangeListener(cu listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.a.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

