/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.cx;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements ae {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int T;
    private Boolean fm;
    private Boolean fn;
    private int fo = -1;
    private CameraPosition fp;
    private Boolean fq;
    private Boolean fr;
    private Boolean fs;
    private Boolean ft;
    private Boolean fu;
    private Boolean fv;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.T = versionCode;
        this.fm = cj.a(zOrderOnTop);
        this.fn = cj.a(useViewLifecycleInFragment);
        this.fo = mapType;
        this.fp = camera;
        this.fq = cj.a(zoomControlsEnabled);
        this.fr = cj.a(compassEnabled);
        this.fs = cj.a(scrollGesturesEnabled);
        this.ft = cj.a(zoomGesturesEnabled);
        this.fu = cj.a(tiltGesturesEnabled);
        this.fv = cj.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aW()) {
            ci.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    public int u() {
        return this.T;
    }

    public byte aH() {
        return cj.b(this.fm);
    }

    public byte aI() {
        return cj.b(this.fn);
    }

    public byte aJ() {
        return cj.b(this.fq);
    }

    public byte aK() {
        return cj.b(this.fr);
    }

    public byte aL() {
        return cj.b(this.fs);
    }

    public byte aM() {
        return cj.b(this.ft);
    }

    public byte aN() {
        return cj.b(this.fu);
    }

    public byte aO() {
        return cj.b(this.fv);
    }

    public GoogleMapOptions() {
        this.T = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.fm = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.fn = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.fo = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.fp = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.fq = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.fr = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.fs = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.ft = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.fu = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.fv = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.fm;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.fn;
    }

    public int getMapType() {
        return this.fo;
    }

    public CameraPosition getCamera() {
        return this.fp;
    }

    public Boolean getZoomControlsEnabled() {
        return this.fq;
    }

    public Boolean getCompassEnabled() {
        return this.fr;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.fs;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.ft;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.fu;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.fv;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

