/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.w;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements ae {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_NO_POWER = 105;
    int T;
    int mPriority = 102;
    long eD = 3600000L;
    long eE = (long)((double)this.eD / 6.0);
    boolean eF = false;
    long ey = Long.MAX_VALUE;
    int eG = Integer.MAX_VALUE;
    float eH = 0.0f;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.I(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.c(millis);
        this.eD = millis;
        if (!this.eF) {
            this.eE = (long)((double)this.eD / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.eD;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.c(millis);
        this.eF = true;
        this.eE = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.eE;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.ey = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.ey < 0L) {
            this.ey = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.ey = millis;
        if (this.ey < 0L) {
            this.ey = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.ey;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.eG = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.eG;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.eH = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.eH;
    }

    private static void c(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void I(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String J(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.J(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.eD + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.eE + "ms");
        if (this.ey != Long.MAX_VALUE) {
            long l2 = this.ey - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.eG != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.eG);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return w.hashCode(this.mPriority, this.eD, this.eE, this.eF, this.ey, this.eG, Float.valueOf(this.eH));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.eD == locationRequest.eD && this.eE == locationRequest.eE && this.eF == locationRequest.eF && this.ey == locationRequest.ey && this.eG == locationRequest.eG && this.eH == locationRequest.eH;
    }
}

