/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.cf;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String ew = null;
        private int ex = 0;
        private long ey = Long.MIN_VALUE;
        private short ez = (short)-1;
        private double eA;
        private double eB;
        private float eC;

        public Builder setRequestId(String requestId) {
            this.ew = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.ex = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.ey = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.ez = 1;
            this.eA = latitude;
            this.eB = longitude;
            this.eC = radius;
            return this;
        }

        public Geofence build() {
            if (this.ew == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.ex == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if (this.ey == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.ez == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            return new cf(this.ew, this.ex, 1, this.eA, this.eB, this.eC, this.ey);
        }
    }
}

