/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.k;
import com.google.android.gms.internal.q;
import com.google.android.gms.internal.t;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.x;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class p<T extends IInterface>
implements GooglePlayServicesClient {
    private final Context mContext;
    final Handler mHandler;
    private T av;
    private ArrayList<GooglePlayServicesClient.ConnectionCallbacks> aw;
    final ArrayList<GooglePlayServicesClient.ConnectionCallbacks> ax = new ArrayList();
    private boolean ay = false;
    private ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> az;
    private boolean aA = false;
    private final ArrayList<b<?>> aB = new ArrayList();
    private e aC;
    private final String[] f;
    boolean aD = false;
    boolean aE = false;
    private final Object aF = new Object();
    public static final String[] aG = new String[]{"service_esmobile", "service_googleme"};

    protected p(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = x.d(context);
        this.aw = new ArrayList();
        this.aw.add(x.d(connectionCallbacks));
        this.az = new ArrayList();
        this.az.add(x.d(onConnectionFailedListener));
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.f = stringArray;
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String b();

    protected abstract String c();

    protected abstract T c(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.aD = true;
        Object object = this.aF;
        synchronized (object) {
            this.aE = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.aC != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.av = null;
            q.e(this.mContext).b(this.b(), this.aC);
        }
        this.aC = new e();
        boolean bl2 = q.e(this.mContext).a(this.b(), this.aC);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.b()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.av != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.aF;
        synchronized (object) {
            return this.aE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.aD = false;
        ArrayList<b<?>> arrayList = this.aF;
        synchronized (arrayList) {
            this.aE = false;
        }
        arrayList = this.aB;
        synchronized (arrayList) {
            int n2 = this.aB.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.aB.get(i2).q();
            }
            this.aB.clear();
        }
        this.av = null;
        if (this.aC != null) {
            q.e(this.mContext).b(this.b(), this.aC);
            this.aC = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] j() {
        return this.f;
    }

    protected final void f(IBinder iBinder) {
        try {
            u u2 = u.a.h(iBinder);
            this.a(u2, new d());
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(u var1, d var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void k() {
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.aw;
        synchronized (arrayList) {
            x.a(!this.ay);
            this.mHandler.removeMessages(4);
            this.ay = true;
            x.a(this.ax.size() == 0);
            Bundle bundle = this.l();
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.aw;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.aD && this.isConnected(); ++i2) {
                int n3 = this.ax.size();
                if (this.ax.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnected(bundle);
            }
            this.ax.clear();
            this.ay = false;
        }
    }

    protected Bundle l() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void m() {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.aw;
        synchronized (arrayList) {
            this.ay = true;
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.aw;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.aD; ++i2) {
                if (!this.aw.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onDisconnected();
            }
            this.ay = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.az;
        synchronized (arrayList) {
            this.aA = true;
            ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList2 = this.az;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.aD) {
                    return;
                }
                if (!this.az.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnectionFailed(connectionResult);
            }
            this.aA = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.aw;
        synchronized (arrayList) {
            if (this.aw.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                if (this.ay) {
                    this.aw = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.aw);
                }
                this.aw.add(listener);
            }
        }
        if (this.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.aw;
        synchronized (arrayList) {
            return this.aw.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.aw;
        synchronized (arrayList) {
            if (this.aw != null) {
                boolean bl2;
                if (this.ay) {
                    this.aw = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.aw);
                }
                if (!(bl2 = this.aw.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
                } else if (this.ay && !this.ax.contains(listener)) {
                    this.ax.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.az;
        synchronized (arrayList) {
            if (this.az.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                if (this.aA) {
                    this.az = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.az);
                }
                this.az.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.az;
        synchronized (arrayList) {
            return this.az.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.az;
        synchronized (arrayList) {
            if (this.az != null) {
                boolean bl2;
                if (this.aA) {
                    this.az = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.az);
                }
                if (!(bl2 = this.az.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
                }
            }
        }
    }

    protected final void n() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    protected final T o() {
        this.n();
        return this.av;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.aB;
        synchronized (arrayList) {
            this.aB.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    public final class d
    extends t.a {
        protected d() {
        }

        public void a(int n2, IBinder iBinder, Bundle bundle) {
            p.this.mHandler.sendMessage(p.this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle aJ;
        public final IBinder aK;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.aK = iBinder;
            this.aJ = bundle;
        }

        @Override
        protected void a(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.aK.getInterfaceDescriptor();
                        if (p.this.c().equals(string2)) {
                            p.this.av = p.this.c(this.aK);
                            if (p.this.av != null) {
                                p.this.k();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    q.e(p.this.mContext).b(p.this.b(), p.this.aC);
                    p.this.aC = null;
                    p.this.av = null;
                    p.this.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.aJ != null) {
                        pendingIntent = (PendingIntent)this.aJ.getParcelable("pendingIntent");
                    }
                    p.this.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        protected final k O;

        public c(TListener TListener, k k2) {
            super(TListener);
            this.O = k2;
        }

        @Override
        protected abstract void a(TListener var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class b<TListener> {
        private TListener mListener;
        private boolean aI;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.aI = false;
        }

        protected abstract void a(TListener var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void p() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.aI) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            this.a(TListener);
            b2 = this;
            synchronized (b2) {
                this.aI = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.q();
            ArrayList arrayList = p.this.aB;
            synchronized (arrayList) {
                p.this.aB.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void q() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Object object = p.this.aF;
            synchronized (object) {
                p.this.aE = false;
            }
            if (msg.what == 3) {
                p.this.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                object = p.this.aw;
                synchronized (object) {
                    if (p.this.aD && p.this.isConnected() && p.this.aw.contains(msg.obj)) {
                        ((GooglePlayServicesClient.ConnectionCallbacks)msg.obj).onConnected(p.this.l());
                    }
                }
                return;
            }
            if (msg.what == 2 && !p.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).p();
                return;
            }
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            p.this.f(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            p.this.av = null;
            p.this.m();
        }
    }
}

