/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ea;
import com.google.android.gms.internal.x;
import com.google.android.gms.internal.y;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.PlusOneButton;

public class dz
extends LinearLayout
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener {
    private static final int hy = Color.parseColor((String)"#666666");
    protected boolean hz;
    protected int hA = 0;
    protected final LinearLayout hB;
    protected final FrameLayout hC;
    protected final CompoundButton hD;
    private final ProgressBar hE;
    protected final ea hF;
    private final dt[] hG = new dt[4];
    protected int bl = 1;
    private int hH = 2;
    private int K = 3;
    private Uri[] hI;
    private String[] hJ;
    private String[] hK;
    protected String hL;
    protected PlusClient hd;
    protected du hM;
    protected final Resources hN;
    protected final LayoutInflater hO;
    private b hP = new b();

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.hd != null) {
            if (!this.hd.isConnectionCallbacksRegistered(this)) {
                this.hd.registerConnectionCallbacks(this);
            }
            if (!this.hd.isConnectionFailedListenerRegistered(this)) {
                this.hd.registerConnectionFailedListener(this);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.hd != null) {
            if (this.hd.isConnectionCallbacksRegistered(this)) {
                this.hd.unregisterConnectionCallbacks(this);
            }
            if (this.hd.isConnectionFailedListenerRegistered(this)) {
                this.hd.unregisterConnectionFailedListener(this);
            }
        }
    }

    public dz(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Context context2;
        x.b(context, (Object)"Context must not be null.");
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(context) != 0) {
            this.hN = null;
            this.hO = null;
        } else {
            context2 = this.k(context);
            this.hN = context2.getResources();
            this.hO = (LayoutInflater)context2.getSystemService("layout_inflater");
        }
        this.K = this.a(context, attributeSet);
        this.hH = this.b(context, attributeSet);
        context2 = new Point();
        this.a((Point)context2);
        if (this.isInEditMode()) {
            TextView textView = new TextView(context);
            textView.setGravity(17);
            textView.setText((CharSequence)"[ +1 ]");
            this.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(context2.x, context2.y));
            this.hF = null;
            this.hE = null;
            this.hD = null;
            this.hC = null;
            this.hB = null;
            return;
        }
        this.setFocusable(true);
        this.hB = new LinearLayout(context);
        this.hB.setGravity(17);
        this.hB.setOrientation(0);
        this.addView((View)this.hB);
        this.hD = new c(context);
        this.hD.setBackgroundDrawable(null);
        this.hF = this.n(context);
        this.hC = this.l(context);
        this.hC.addView((View)this.hD, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        this.b((Point)context2);
        this.hE = this.m(context);
        this.hE.setVisibility(4);
        this.hC.addView((View)this.hE, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        int n2 = this.hG.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.hG[i2] = this.o(this.getContext());
        }
        this.bn();
    }

    private int a(Context context, AttributeSet attributeSet) {
        String string2 = ab.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attributeSet, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : ("STANDARD".equalsIgnoreCase(string2) ? 3 : 3)));
    }

    private int b(Context context, AttributeSet attributeSet) {
        String string2 = ab.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attributeSet, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : ("BUBBLE".equalsIgnoreCase(string2) ? 1 : 1));
    }

    private Context k(Context context) {
        try {
            return this.getContext().createPackageContext("com.google.android.gms", 4);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"PlusOneButton", (int)5)) {
                Log.w((String)"PlusOneButton", (String)"Google Play services is not installed");
            }
            return null;
        }
    }

    public void initialize(PlusClient plusClient, String url, int activityRequestCode) {
        x.b(plusClient, (Object)"Plus client must not be null.");
        x.b(url, (Object)"URL must not be null.");
        x.a(activityRequestCode >= 0 && activityRequestCode <= 65535, "activityRequestCode must be an unsigned 16 bit integer.");
        this.hA = activityRequestCode;
        this.hL = url;
        if (plusClient != this.hd) {
            if (this.hd != null) {
                this.hd.unregisterConnectionCallbacks(this);
                this.hd.unregisterConnectionFailedListener(this);
            }
            this.hd = plusClient;
            this.hd.registerConnectionCallbacks(this);
            this.hd.registerConnectionFailedListener(this);
            int n2 = this.hG.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.hG[i2].a(plusClient);
            }
        } else if (this.hd.isConnected()) {
            this.onConnected(null);
        }
        this.bj();
    }

    public void onConnected(Bundle connectionHint) {
        if (this.hL != null) {
            this.hd.a(this.hP, this.hL);
        }
    }

    public void onConnectionFailed(ConnectionResult status) {
        this.bm();
    }

    public void onDisconnected() {
    }

    public void setOnPlusOneClickListener(PlusOneButton.OnPlusOneClickListener listener) {
        this.setOnClickListener(new a(listener));
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.hD.setOnClickListener(listener);
        this.hF.setOnClickListener(listener);
    }

    public boolean performClick() {
        return this.hD.performClick();
    }

    private void a(Uri[] uriArray) {
        this.hI = uriArray;
        this.br();
    }

    private void d(String[] stringArray) {
        this.hJ = stringArray;
        this.bq();
    }

    private void e(String[] stringArray) {
        this.hK = stringArray;
        this.bq();
    }

    public void setAnnotation(int annotation) {
        x.b(annotation, (Object)"Annotation must not be null.");
        this.hH = annotation;
        this.bq();
        this.bj();
    }

    private void c(View view) {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        view.setPadding(this.hH == 2 ? n3 : 0, 0, 0, this.K == 2 && this.hH == 1 ? n2 : 0);
    }

    private void bi() {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        boolean bl2 = true;
        int n4 = this.hG.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.hG[i2].getVisibility() != 0) continue;
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.hG[i2].getLayoutParams());
            if (bl2) {
                layoutParams.setMargins(n2, 0, n3, 0);
                bl2 = false;
            } else {
                layoutParams.setMargins(n3, 0, n3, 0);
            }
            this.hG[i2].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setSize(int size) {
        this.c(size, this.bl);
    }

    public void setType(int type) {
        this.c(this.K, type);
    }

    private void c(int n2, int n3) {
        this.bl = n3;
        this.K = n2;
        this.bj();
    }

    protected void bj() {
        if (this.isInEditMode()) {
            return;
        }
        this.hB.removeAllViews();
        Point point = new Point();
        this.a(point);
        this.hD.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        this.b(point);
        this.hE.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        if (this.hH == 1) {
            this.hF.b(this.bu());
        } else {
            this.hF.b(null);
        }
        this.br();
        this.hF.setLayoutParams((ViewGroup.LayoutParams)this.bk());
        float f2 = TypedValue.applyDimension((int)2, (float)dz.d(this.K, this.hH), (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.hF.setTextSize(0, f2);
        this.c((View)this.hF);
        if (this.K == 2 && this.hH == 1) {
            this.hB.setOrientation(1);
            this.hB.addView((View)this.hF);
            this.hB.addView((View)this.hC);
        } else {
            this.hB.setOrientation(0);
            this.hB.addView((View)this.hC);
            int n2 = this.hG.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.hB.addView((View)this.hG[i2]);
            }
            this.hB.addView((View)this.hF);
        }
        this.requestLayout();
    }

    private FrameLayout l(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setFocusable(false);
        return frameLayout;
    }

    private ProgressBar m(Context context) {
        boolean bl2 = true;
        ProgressBar progressBar = new ProgressBar(context, null, 16843400);
        progressBar.setFocusable(false);
        progressBar.setIndeterminate(true);
        return progressBar;
    }

    private ea n(Context context) {
        ea ea2 = new ea(context);
        ea2.setFocusable(false);
        ea2.setGravity(17);
        ea2.setSingleLine();
        float f2 = TypedValue.applyDimension((int)2, (float)dz.d(this.K, this.hH), (DisplayMetrics)context.getResources().getDisplayMetrics());
        ea2.setTextSize(0, f2);
        ea2.setTextColor(hy);
        ea2.setVisibility(0);
        return ea2;
    }

    private dt o(Context context) {
        dt dt2 = new dt(context);
        dt2.setVisibility(8);
        return dt2;
    }

    private static int d(int n2, int n3) {
        switch (n2) {
            case 2: {
                if (n3 == 2) {
                    return 13;
                }
                return 15;
            }
            case 0: {
                return 11;
            }
            case 1: {
                return 13;
            }
        }
        return 13;
    }

    private LinearLayout.LayoutParams bk() {
        LinearLayout.LayoutParams layoutParams;
        switch (this.hH) {
            case 2: {
                layoutParams = new LinearLayout.LayoutParams(-2, -1);
                break;
            }
            case 1: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
                break;
            }
            default: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
            }
        }
        layoutParams.bottomMargin = this.K == 2 ? 1 : 0;
        layoutParams.leftMargin = this.K == 2 ? 0 : 1;
        return layoutParams;
    }

    public void bl() {
        this.setType(2);
        this.hE.setVisibility(0);
        this.bp();
    }

    public void bm() {
        this.setType(3);
        this.hE.setVisibility(4);
        this.bp();
    }

    protected void bn() {
        this.setType(1);
        this.hE.setVisibility(4);
        this.bp();
    }

    protected void bo() {
        this.setType(0);
        this.hE.setVisibility(4);
        this.bp();
    }

    protected void bd() {
        if (this.hM == null) {
            return;
        }
        this.d(this.hM.bg());
        this.e(new String[]{this.hM.bf()});
        this.a(this.hM.bh());
        if (this.hM.be()) {
            this.bo();
        } else {
            this.bn();
        }
    }

    protected void bp() {
        this.hD.setButtonDrawable(this.bs());
        switch (this.bl) {
            case 0: {
                this.hD.setEnabled(true);
                this.hD.setChecked(true);
                break;
            }
            case 1: {
                this.hD.setEnabled(true);
                this.hD.setChecked(false);
                break;
            }
            case 2: {
                this.hD.setEnabled(false);
                this.hD.setChecked(true);
                break;
            }
            default: {
                this.hD.setEnabled(false);
                this.hD.setChecked(false);
            }
        }
    }

    private void bq() {
        switch (this.hH) {
            case 2: {
                this.hF.f(this.hJ);
                this.hF.setVisibility(0);
                break;
            }
            case 1: {
                this.hF.f(this.hK);
                this.hF.setVisibility(0);
                break;
            }
            default: {
                this.hF.f(null);
                this.hF.setVisibility(8);
            }
        }
    }

    private void br() {
        if (this.hI != null && this.hH == 2) {
            Point point = new Point();
            this.a(point);
            point.x = point.y;
            int n2 = this.hG.length;
            int n3 = this.hI.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Uri uri;
                Uri uri2 = uri = i2 < n3 ? this.hI[i2] : null;
                if (uri == null) {
                    this.hG[i2].setVisibility(8);
                    continue;
                }
                this.hG[i2].setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(point.x, point.y));
                this.hG[i2].a(uri, point.y);
                this.hG[i2].setVisibility(0);
            }
        } else {
            int n4 = this.hG.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.hG[i3].setVisibility(8);
            }
        }
        this.bi();
    }

    private void a(Point point) {
        int n2;
        int n3;
        switch (this.K) {
            case 1: {
                n3 = 32;
                n2 = 20;
                break;
            }
            case 0: {
                n3 = 24;
                n2 = 14;
                break;
            }
            case 2: {
                n3 = 50;
                n2 = 20;
                break;
            }
            default: {
                n3 = 38;
                n2 = 24;
            }
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f2 = TypedValue.applyDimension((int)1, (float)n3, (DisplayMetrics)displayMetrics);
        float f3 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)displayMetrics);
        point.x = (int)((double)f2 + 0.5);
        point.y = (int)((double)f3 + 0.5);
    }

    private void b(Point point) {
        point.x = point.y = (int)((float)point.y - TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    private Drawable bs() {
        return this.hN == null ? null : this.hN.getDrawable(this.hN.getIdentifier(this.bt(), "drawable", "com.google.android.gms"));
    }

    private String bt() {
        switch (this.K) {
            case 0: {
                return "ic_plusone_small";
            }
            case 1: {
                return "ic_plusone_medium";
            }
            case 2: {
                return "ic_plusone_tall";
            }
        }
        return "ic_plusone_standard";
    }

    private Uri bu() {
        return y.i(this.bv());
    }

    private String bv() {
        switch (this.K) {
            case 1: {
                return "global_count_bubble_medium";
            }
            case 0: {
                return "global_count_bubble_small";
            }
            case 2: {
                return "global_count_bubble_tall";
            }
        }
        return "global_count_bubble_standard";
    }

    public class b
    implements PlusClient.b {
        protected b() {
        }

        public void a(ConnectionResult connectionResult, du du2) {
            if (dz.this.hz) {
                dz.this.hz = false;
                dz.this.hD.refreshDrawableState();
            }
            if (connectionResult.isSuccess() && du2 != null) {
                dz.this.hM = du2;
                dz.this.bd();
                dz.this.bj();
            } else {
                dz.this.bm();
            }
        }
    }

    class c
    extends CompoundButton {
        public c(Context context) {
            super(context);
        }

        public void toggle() {
            if (dz.this.hz) {
                super.toggle();
            } else {
                dz.this.hz = true;
                dz.this.bl();
            }
        }
    }

    class a
    implements View.OnClickListener,
    PlusOneButton.OnPlusOneClickListener {
        private final PlusOneButton.OnPlusOneClickListener hQ;

        public a(PlusOneButton.OnPlusOneClickListener onPlusOneClickListener) {
            this.hQ = onPlusOneClickListener;
        }

        public void onClick(View view) {
            if (view == dz.this.hD || view == dz.this.hF) {
                Intent intent;
                Intent intent2 = intent = dz.this.hM == null ? null : dz.this.hM.getIntent();
                if (this.hQ != null) {
                    this.hQ.onPlusOneClick(intent);
                } else {
                    this.onPlusOneClick(intent);
                }
            }
        }

        public void onPlusOneClick(Intent intent) {
            Context context = dz.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, dz.this.hA);
            }
        }
    }
}

