/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.cb;
import com.google.android.gms.internal.cc;
import com.google.android.gms.internal.cd;
import com.google.android.gms.internal.cf;
import com.google.android.gms.internal.ch;
import com.google.android.gms.internal.n;
import com.google.android.gms.internal.p;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.x;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ce
extends p<cc> {
    private final ch<cc> eI = new c();
    private final cd eN;
    private final String eO;

    public ce(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.eN = new cd(context, this.eI);
        this.eO = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        cd cd2 = this.eN;
        synchronized (cd2) {
            if (this.isConnected()) {
                this.eN.removeAllListeners();
            }
            super.disconnect();
        }
    }

    @Override
    protected String b() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String c() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.n();
        x.d(callbackIntent);
        x.b(detectionIntervalMillis >= 0L, (Object)"detectionIntervalMillis must be >= 0");
        try {
            ((cc)this.o()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.n();
        x.d(callbackIntent);
        try {
            ((cc)this.o()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<cf> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.n();
        x.b(geofences != null && geofences.size() > 0, (Object)"At least one geofence must be specified.");
        x.b(pendingIntent, (Object)"PendingIntent must be specified.");
        x.b(listener, (Object)"OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener);
            ((cc)this.o()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.n();
        x.b(pendingIntent, (Object)"PendingIntent must be specified.");
        x.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener);
            ((cc)this.o()).a(pendingIntent, (cb)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.n();
        x.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, (Object)"geofenceRequestIds can't be null nor empty.");
        x.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener);
            ((cc)this.o()).a(stringArray, (cb)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.eN.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        cd cd2 = this.eN;
        synchronized (cd2) {
            this.eN.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.eN.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.eN.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.eN.removeLocationUpdates(callbackIntent);
    }

    protected cc q(IBinder iBinder) {
        return cc.a.p(iBinder);
    }

    @Override
    protected void a(u u2, p.d d2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.eO);
        u2.e(d2, 3159100, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface c(IBinder iBinder) {
        return this.q(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends p.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int p;
        private final String[] eP;
        private final PendingIntent mPendingIntent;
        private final int eT;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(ce.this, onRemoveGeofencesResultListener);
            n.a(n2 == 2);
            this.eT = n2;
            this.p = LocationStatusCodes.K(n3);
            this.eP = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(ce.this, onRemoveGeofencesResultListener);
            n.a(n2 == 1);
            this.eT = n2;
            this.p = LocationStatusCodes.K(n3);
            this.mPendingIntent = pendingIntent;
            this.eP = null;
        }

        @Override
        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.eT) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.p, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.p, this.eP);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.eT));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class a
    extends p.b<LocationClient.OnAddGeofencesResultListener> {
        private final int p;
        private final String[] eP;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(ce.this, onAddGeofencesResultListener);
            this.p = LocationStatusCodes.K(n2);
            this.eP = stringArray;
        }

        @Override
        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.p, this.eP);
            }
        }
    }

    final class b
    extends cb.a {
        private final LocationClient.OnAddGeofencesResultListener eR;
        private final LocationClient.OnRemoveGeofencesResultListener eS;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            this.eR = onAddGeofencesResultListener;
            this.eS = null;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            this.eS = onRemoveGeofencesResultListener;
            this.eR = null;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            ce.this.a(new a(this.eR, statusCode, geofenceRequestIds));
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            ce.this.a(new d(2, this.eS, statusCode, geofenceRequestIds));
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            ce.this.a(new d(1, this.eS, statusCode, pendingIntent));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class c
    implements ch<cc> {
        private c() {
        }

        @Override
        public void n() {
            ce.this.n();
        }

        public cc aA() {
            return (cc)ce.this.o();
        }

        @Override
        public /* synthetic */ IInterface o() {
            return this.aA();
        }
    }
}

