/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.RealTimeSocket;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.leaderboard.SubmitScoreResult;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.bi;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.bl;
import com.google.android.gms.internal.bm;
import com.google.android.gms.internal.bn;
import com.google.android.gms.internal.bo;
import com.google.android.gms.internal.by;
import com.google.android.gms.internal.p;
import com.google.android.gms.internal.t;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class bj
extends com.google.android.gms.internal.p<bm> {
    private final String cB;
    private final String g;
    private final Map<String, bo> cC;
    private PlayerEntity cD;
    private GameEntity cE;
    private final bn cF;
    private boolean cG = false;
    private final Binder cH;
    private final long cI;
    private final boolean cJ;

    public bj(Context context, String string2, String string3, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.cB = string2;
        this.g = com.google.android.gms.internal.x.d(string3);
        this.cH = new Binder();
        this.cC = new HashMap<String, bo>();
        this.cF = bn.a(this, n2);
        this.setViewForPopups(view);
        this.cI = this.hashCode();
        this.cJ = bl2;
    }

    public void setGravityForPopups(int gravity) {
        this.cF.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.cF.a(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            com.google.android.gms.internal.x.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            com.google.android.gms.internal.x.a(bl2, String.format("GamesClient requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.ah();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.cG = false;
        if (this.isConnected()) {
            try {
                bm bm2 = (bm)this.o();
                bm2.aj();
                bm2.b(this.cI);
                bm2.a(this.cI);
            }
            catch (RemoteException remoteException) {
                bk.b("GamesClient", "Failed to notify client disconnect.");
            }
        }
        this.ai();
        super.disconnect();
    }

    @Override
    protected String b() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String c() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected bm k(IBinder iBinder) {
        return bm.a.m(iBinder);
    }

    @Override
    protected Bundle l() {
        try {
            Bundle bundle = ((bm)this.o()).l();
            if (bundle != null) {
                bundle.setClassLoader(bj.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return null;
        }
    }

    private void ah() {
        this.cD = null;
    }

    @Override
    protected void a(com.google.android.gms.internal.u u2, p.d d2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        j j2 = new j(d2);
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.cJ);
        u2.a(j2, 3159100, this.getContext().getPackageName(), this.g, this.j(), this.cB, this.cF.ap(), string2, bundle);
    }

    @Override
    protected void k() {
        super.k();
        if (this.cG) {
            this.cF.an();
            this.cG = false;
        }
    }

    @Override
    protected void a(ConnectionResult connectionResult) {
        super.a(connectionResult);
        this.cG = false;
    }

    public String getCurrentAccountName() {
        try {
            return ((bm)this.o()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((bm)this.o()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.n();
        bj bj2 = this;
        synchronized (bj2) {
            if (this.cD == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((bm)this.o()).ak());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.cD = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    bk.b("GamesClient", "service died");
                }
            }
        }
        return this.cD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.n();
        bj bj2 = this;
        synchronized (bj2) {
            if (this.cE == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((bm)this.o()).am());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.cE = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    bk.b("GamesClient", "service died");
                }
            }
        }
        return this.cE;
    }

    public void loadPlayer(OnPlayersLoadedListener listener, String playerId) {
        try {
            ((bm)this.o()).c(new ad(listener), playerId);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void a(OnPlayersLoadedListener onPlayersLoadedListener, int n2, boolean bl2, boolean bl3) {
        try {
            ((bm)this.o()).a((bl)new ad(onPlayersLoadedListener), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARDS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.cB);
        intent.addFlags(0x4000000);
        return intent;
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARD_SCORES");
        intent.putExtra("com.google.android.gms.games.LEADERBOARD_ID", leaderboardId);
        intent.addFlags(0x4000000);
        return intent;
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener) {
        try {
            ((bm)this.o()).b(new t(listener));
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, String leaderboardId) {
        try {
            ((bm)this.o()).d(new t(listener), leaderboardId);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((bm)this.o()).a(new r(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((bm)this.o()).b(new r(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void loadMoreScores(OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        try {
            ((bm)this.o()).a((bl)new r(listener), buffer.ar().as(), maxResults, pageDirection);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void a(OnScoreSubmittedListener onScoreSubmittedListener, String string2, long l2) {
        try {
            ao ao2 = onScoreSubmittedListener == null ? null : new ao(onScoreSubmittedListener);
            ((bm)this.o()).a((bl)ao2, string2, l2);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_ACHIEVEMENTS");
        intent.addFlags(0x4000000);
        return intent;
    }

    public void loadAchievements(OnAchievementsLoadedListener listener) {
        try {
            ((bm)this.o()).c(new f(listener));
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bm)this.o()).a((bl)d2, string2, this.cF.ap(), this.cF.ao());
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void b(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bm)this.o()).b((bl)d2, string2, this.cF.ap(), this.cF.ao());
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2, int n2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bm)this.o()).a((bl)d2, string2, n2, this.cF.ap(), this.cF.ao());
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public Intent getInvitationInboxIntent() {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_INVITATIONS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.cB);
        return intent;
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            m m2 = new m(listener);
            ((bm)this.o()).a((bl)m2, this.cI);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((bm)this.o()).b(this.cI);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.SELECT_PLAYERS");
        intent.putExtra("com.google.android.gms.games.MIN_SELECTIONS", minPlayers);
        intent.putExtra("com.google.android.gms.games.MAX_SELECTIONS", maxPlayers);
        return intent;
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_REAL_TIME_WAITING_ROOM");
        com.google.android.gms.internal.x.b(room, (Object)"Room parameter must not be null");
        intent.putExtra("room", (Parcelable)room.freeze());
        com.google.android.gms.internal.x.a(minParticipantsToStart >= 0, "minParticipantsToStart must be >= 0");
        intent.putExtra("com.google.android.gms.games.MIN_PARTICIPANTS_TO_START", minParticipantsToStart);
        return intent;
    }

    public Intent getSettingsIntent() {
        this.n();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_SETTINGS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.cB);
        intent.addFlags(0x4000000);
        return intent;
    }

    public void loadGame(OnGamesLoadedListener listener) {
        try {
            ((bm)this.o()).d(new k(listener));
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void signOut(OnSignOutCompleteListener listener) {
        try {
            am am2 = listener == null ? null : new am(listener);
            ((bm)this.o()).a(am2);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public String getAppId() {
        try {
            return ((bm)this.o()).getAppId();
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return null;
        }
    }

    public void loadInvitations(OnInvitationsLoadedListener listener) {
        try {
            ((bm)this.o()).e(new o(listener));
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void h(String string2, int n2) {
        try {
            ((bm)this.o()).h(string2, n2);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void i(String string2, int n2) {
        try {
            ((bm)this.o()).i(string2, n2);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void createRoom(RoomConfig config) {
        try {
            ai ai2 = new ai(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((bm)this.o()).a((bl)ai2, (IBinder)this.cH, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.cI);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            ai ai2 = new ai(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((bm)this.o()).a((bl)ai2, (IBinder)this.cH, config.getInvitationId(), config.isSocketEnabled(), this.cI);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((bm)this.o()).e(new ai(listener), roomId);
            this.ai();
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public int sendReliableRealTimeMessage(RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        try {
            return ((bm)this.o()).a((bl)new ag(listener), messageData, roomId, recipientParticipantId);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        com.google.android.gms.internal.x.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((bm)this.o()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((bm)this.o()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.v(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        bo bo2 = this.cC.get(participantId);
        if (bo2 == null || bo2.isClosed()) {
            return this.p(participantId);
        }
        return bo2;
    }

    private bo p(String string2) {
        try {
            String string3 = ((bm)this.o()).r(string2);
            if (string3 == null) {
                return null;
            }
            bk.d("GamesClient", "Creating a socket to bind to:" + string3);
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                bk.c("GamesClient", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            bo bo2 = new bo(localSocket, string2);
            this.cC.put(string2, bo2);
            return bo2;
        }
        catch (RemoteException remoteException) {
            bk.c("GamesClient", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((bm)this.o()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    public void setUseNewPlayerNotificationsFirstParty(boolean newPlayerStyle) {
        try {
            ((bm)this.o()).setUseNewPlayerNotificationsFirstParty(newPlayerStyle);
        }
        catch (RemoteException remoteException) {
            bk.b("GamesClient", "service died");
        }
    }

    private void ai() {
        for (bo bo2 : this.cC.values()) {
            try {
                bo2.close();
            }
            catch (IOException iOException) {
                bk.a("GamesClient", "IOException:", iOException);
            }
        }
        this.cC.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((bm)this.o()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                bk.b("GamesClient", "service died");
            }
        }
    }

    public void aj() {
        if (this.isConnected()) {
            try {
                ((bm)this.o()).aj();
            }
            catch (RemoteException remoteException) {
                bk.b("GamesClient", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room x(com.google.android.gms.internal.k k2) {
        by by2 = new by(k2);
        Room room = null;
        try {
            if (by2.getCount() > 0) {
                room = (Room)((Room)by2.get(0)).freeze();
            }
        }
        finally {
            by2.close();
        }
        return room;
    }

    @Override
    protected /* synthetic */ IInterface c(IBinder iBinder) {
        return this.k(iBinder);
    }

    public final class j
    extends t.a {
        private final p.d cP;

        public j(p.d d2) {
            this.cP = d2;
        }

        public void a(int n2, IBinder iBinder, Bundle bundle) {
            this.cP.a(n2, iBinder, bundle);
            if (n2 == 0 && bundle != null) {
                bj.this.cG = bundle.getBoolean("show_welcome_popup");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class an
    extends p.b<OnSignOutCompleteListener> {
        public an(OnSignOutCompleteListener onSignOutCompleteListener) {
            super(onSignOutCompleteListener);
        }

        @Override
        public void a(OnSignOutCompleteListener onSignOutCompleteListener) {
            onSignOutCompleteListener.onSignOutComplete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends p.b<RealTimeReliableMessageSentListener> {
        private final int p;
        private final String db;
        private final int dc;

        af(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener, int n2, int n3, String string2) {
            super(realTimeReliableMessageSentListener);
            this.p = n2;
            this.dc = n3;
            this.db = string2;
        }

        @Override
        public void a(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            if (realTimeReliableMessageSentListener != null) {
                realTimeReliableMessageSentListener.onRealTimeMessageSent(this.p, this.dc, this.db);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends p.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage cZ;

        w(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(realTimeMessageReceivedListener);
            this.cZ = realTimeMessage;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            bk.a("GamesClient", "Deliver Message received callback");
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.cZ);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends a {
        z(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class x
    extends a {
        x(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeersConnected(room, arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends a {
        y(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeerDeclined(room, arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeerLeft(room, arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends a {
        ab(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeerJoined(room, arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends a {
        aa(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
            }
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomStatusUpdateListener, k2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onDisconnectedFromRoom(room);
            }
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomStatusUpdateListener, k2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onConnectedToRoom(room);
            }
        }
    }

    final class ah
    extends c {
        ah(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomStatusUpdateListener, k2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onRoomAutoMatching(room);
            }
        }
    }

    final class ak
    extends c {
        ak(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomStatusUpdateListener, k2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onRoomConnecting(room);
            }
        }
    }

    final class aj
    extends b {
        aj(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomUpdateListener, k2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room) {
            if (roomUpdateListener != null) {
                roomUpdateListener.onRoomConnected(this.O.getStatusCode(), room);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends p.b<RoomUpdateListener> {
        private final int p;
        private final String cY;

        v(RoomUpdateListener roomUpdateListener, int n2, String string2) {
            super(roomUpdateListener);
            this.p = n2;
            this.cY = string2;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.p, this.cY);
        }
    }

    final class q
    extends b {
        public q(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomUpdateListener, k2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room) {
            roomUpdateListener.onJoinedRoom(this.O.getStatusCode(), room);
        }
    }

    final class al
    extends b {
        public al(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomUpdateListener, k2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room) {
            roomUpdateListener.onRoomCreated(this.O.getStatusCode(), room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> cK;

        a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2, String[] stringArray) {
            super(roomStatusUpdateListener, k2);
            this.cK = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.cK.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            if (roomStatusUpdateListener != null) {
                this.a(roomStatusUpdateListener, room, this.cK);
            }
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends p.c<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomStatusUpdateListener, k2);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                this.a(roomStatusUpdateListener, bj.this.x(this.O));
            }
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends p.c<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.k k2) {
            super(roomUpdateListener, k2);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener) {
            this.a(roomUpdateListener, bj.this.x(this.O));
        }

        protected abstract void a(RoomUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ap
    extends p.b<OnScoreSubmittedListener> {
        private final SubmitScoreResult dj;

        public ap(OnScoreSubmittedListener onScoreSubmittedListener, SubmitScoreResult submitScoreResult) {
            super(onScoreSubmittedListener);
            this.dj = submitScoreResult;
        }

        @Override
        public void a(OnScoreSubmittedListener onScoreSubmittedListener) {
            onScoreSubmittedListener.onScoreSubmitted(this.dj.getStatusCode(), this.dj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ae
    extends p.c<OnPlayersLoadedListener> {
        ae(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.internal.k k2) {
            super(onPlayersLoadedListener, k2);
        }

        @Override
        protected void a(OnPlayersLoadedListener onPlayersLoadedListener) {
            onPlayersLoadedListener.onPlayersLoaded(this.O.getStatusCode(), new PlayerBuffer(this.O));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class n
    extends p.b<OnInvitationReceivedListener> {
        private final Invitation cS;

        n(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(onInvitationReceivedListener);
            this.cS = invitation;
        }

        @Override
        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.cS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class p
    extends p.c<OnInvitationsLoadedListener> {
        p(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.internal.k k2) {
            super(onInvitationsLoadedListener, k2);
        }

        @Override
        protected void a(OnInvitationsLoadedListener onInvitationsLoadedListener) {
            onInvitationsLoadedListener.onInvitationsLoaded(this.O.getStatusCode(), new InvitationBuffer(this.O));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class s
    extends p.b<OnLeaderboardScoresLoadedListener> {
        private final com.google.android.gms.internal.k cV;
        private final com.google.android.gms.internal.k cW;

        s(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener, com.google.android.gms.internal.k k2, com.google.android.gms.internal.k k3) {
            super(onLeaderboardScoresLoadedListener);
            this.cV = k2;
            this.cW = k3;
        }

        @Override
        protected void a(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(this.cV);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(this.cW);
            onLeaderboardScoresLoadedListener.onLeaderboardScoresLoaded(this.cW.getStatusCode(), leaderboardBuffer, leaderboardScoreBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends p.c<OnLeaderboardMetadataLoadedListener> {
        u(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.internal.k k2) {
            super(onLeaderboardMetadataLoadedListener, k2);
        }

        @Override
        protected void a(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener) {
            onLeaderboardMetadataLoadedListener.onLeaderboardMetadataLoaded(this.O.getStatusCode(), new LeaderboardBuffer(this.O));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class l
    extends p.c<OnGamesLoadedListener> {
        l(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.internal.k k2) {
            super(onGamesLoadedListener, k2);
        }

        @Override
        protected void a(OnGamesLoadedListener onGamesLoadedListener) {
            onGamesLoadedListener.onGamesLoaded(this.O.getStatusCode(), new GameBuffer(this.O));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends p.b<OnAchievementUpdatedListener> {
        private final int p;
        private final String cN;

        e(OnAchievementUpdatedListener onAchievementUpdatedListener, int n2, String string2) {
            super(onAchievementUpdatedListener);
            this.p = n2;
            this.cN = string2;
        }

        @Override
        protected void a(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            onAchievementUpdatedListener.onAchievementUpdated(this.p, this.cN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends p.c<OnAchievementsLoadedListener> {
        g(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.internal.k k2) {
            super(onAchievementsLoadedListener, k2);
        }

        @Override
        protected void a(OnAchievementsLoadedListener onAchievementsLoadedListener) {
            onAchievementsLoadedListener.onAchievementsLoaded(this.O.getStatusCode(), new AchievementBuffer(this.O));
        }
    }

    final class am
    extends bi {
        private final OnSignOutCompleteListener dh;

        public am(OnSignOutCompleteListener onSignOutCompleteListener) {
            this.dh = com.google.android.gms.internal.x.b(onSignOutCompleteListener, (Object)"Listener must not be null");
        }

        public void onSignOutComplete() {
            bj.this.a(new an(this.dh));
        }
    }

    final class ag
    extends bi {
        final RealTimeReliableMessageSentListener dd;

        public ag(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            this.dd = realTimeReliableMessageSentListener;
        }

        public void a(int n2, int n3, String string2) {
            bj.this.a(new af(this.dd, n2, n3, string2));
        }
    }

    final class ai
    extends bi {
        private final RoomUpdateListener de;
        private final RoomStatusUpdateListener df;
        private final RealTimeMessageReceivedListener dg;

        public ai(RoomUpdateListener roomUpdateListener) {
            this.de = com.google.android.gms.internal.x.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.df = null;
            this.dg = null;
        }

        public ai(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.de = com.google.android.gms.internal.x.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.df = roomStatusUpdateListener;
            this.dg = realTimeMessageReceivedListener;
        }

        public void n(com.google.android.gms.internal.k k2) {
            bj.this.a(new al(this.de, k2));
        }

        public void o(com.google.android.gms.internal.k k2) {
            bj.this.a(new q(this.de, k2));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            bj.this.a(new v(this.de, statusCode, externalRoomId));
        }

        public void r(com.google.android.gms.internal.k k2) {
            bj.this.a(new aj(this.de, k2));
        }

        public void p(com.google.android.gms.internal.k k2) {
            bj.this.a(new ak(this.df, k2));
        }

        public void q(com.google.android.gms.internal.k k2) {
            bj.this.a(new ah(this.df, k2));
        }

        public void s(com.google.android.gms.internal.k k2) {
            bj.this.a(new h(this.df, k2));
        }

        public void t(com.google.android.gms.internal.k k2) {
            bj.this.a(new i(this.df, k2));
        }

        public void e(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new x(this.df, k2, stringArray));
        }

        public void f(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new z(this.df, k2, stringArray));
        }

        public void a(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new aa(this.df, k2, stringArray));
        }

        public void b(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new ab(this.df, k2, stringArray));
        }

        public void c(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new ac(this.df, k2, stringArray));
        }

        public void d(com.google.android.gms.internal.k k2, String[] stringArray) {
            bj.this.a(new y(this.df, k2, stringArray));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            bk.a("GamesClient", "RoomBinderCallbacks: onRealTimeMessageReceived");
            bj.this.a(new w(this.dg, message));
        }
    }

    final class ao
    extends bi {
        private final OnScoreSubmittedListener di;

        public ao(OnScoreSubmittedListener onScoreSubmittedListener) {
            this.di = com.google.android.gms.internal.x.b(onScoreSubmittedListener, (Object)"Listener must not be null");
        }

        public void d(com.google.android.gms.internal.k k2) {
            SubmitScoreResult submitScoreResult = new SubmitScoreResult(k2);
            bj.this.a(new ap(this.di, submitScoreResult));
        }
    }

    final class ad
    extends bi {
        private final OnPlayersLoadedListener da;

        ad(OnPlayersLoadedListener onPlayersLoadedListener) {
            this.da = com.google.android.gms.internal.x.b(onPlayersLoadedListener, (Object)"Listener must not be null");
        }

        public void e(com.google.android.gms.internal.k k2) {
            bj.this.a(new ae(this.da, k2));
        }
    }

    final class m
    extends bi {
        private final OnInvitationReceivedListener cR;

        m(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.cR = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k(com.google.android.gms.internal.k k2) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(k2);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.close();
            }
            if (invitation != null) {
                bj.this.a(new n(this.cR, invitation));
            }
        }
    }

    final class o
    extends bi {
        private final OnInvitationsLoadedListener cT;

        o(OnInvitationsLoadedListener onInvitationsLoadedListener) {
            this.cT = onInvitationsLoadedListener;
        }

        public void j(com.google.android.gms.internal.k k2) {
            bj.this.a(new p(this.cT, k2));
        }
    }

    final class r
    extends bi {
        private final OnLeaderboardScoresLoadedListener cU;

        r(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            this.cU = com.google.android.gms.internal.x.b(onLeaderboardScoresLoadedListener, (Object)"Listener must not be null");
        }

        public void a(com.google.android.gms.internal.k k2, com.google.android.gms.internal.k k3) {
            bj.this.a(new s(this.cU, k2, k3));
        }
    }

    final class t
    extends bi {
        private final OnLeaderboardMetadataLoadedListener cX;

        t(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener) {
            this.cX = com.google.android.gms.internal.x.b(onLeaderboardMetadataLoadedListener, (Object)"Listener must not be null");
        }

        public void c(com.google.android.gms.internal.k k2) {
            bj.this.a(new u(this.cX, k2));
        }
    }

    final class k
    extends bi {
        private final OnGamesLoadedListener cQ;

        k(OnGamesLoadedListener onGamesLoadedListener) {
            this.cQ = com.google.android.gms.internal.x.b(onGamesLoadedListener, (Object)"Listener must not be null");
        }

        public void g(com.google.android.gms.internal.k k2) {
            bj.this.a(new l(this.cQ, k2));
        }
    }

    final class d
    extends bi {
        private final OnAchievementUpdatedListener cM;

        d(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            this.cM = com.google.android.gms.internal.x.b(onAchievementUpdatedListener, (Object)"Listener must not be null");
        }

        public void onAchievementUpdated(int statusCode, String achievementId) {
            bj.this.a(new e(this.cM, statusCode, achievementId));
        }
    }

    final class f
    extends bi {
        private final OnAchievementsLoadedListener cO;

        f(OnAchievementsLoadedListener onAchievementsLoadedListener) {
            this.cO = com.google.android.gms.internal.x.b(onAchievementsLoadedListener, (Object)"Listener must not be null");
        }

        public void b(com.google.android.gms.internal.k k2) {
            bj.this.a(new g(this.cO, k2));
        }
    }
}

