/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GoogleCloudMessaging {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    static GoogleCloudMessaging ej;
    private Context ek;
    private PendingIntent el;
    final BlockingQueue<Intent> em = new LinkedBlockingQueue<Intent>();
    private Handler en = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Intent intent = (Intent)msg.obj;
            GoogleCloudMessaging.this.em.add(intent);
        }
    };
    private Messenger eo = new Messenger(this.en);

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (ej == null) {
            ej = new GoogleCloudMessaging();
            GoogleCloudMessaging.ej.ek = context;
        }
        return ej;
    }

    public void close() {
        this.ay();
    }

    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (to == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.putExtras(data);
        this.b(intent);
        intent.putExtra("google.to", to);
        intent.putExtra("google.message_id", msgId);
        intent.putExtra("google.ttl", Long.toString(timeToLive));
        this.ek.sendOrderedBroadcast(intent, null);
    }

    public void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.ax();
        try {
            Intent intent = this.em.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string = intent.getStringExtra("unregistered");
            if (string != null) {
                return;
            }
            String string2 = intent.getStringExtra("error");
            if (string2 != null) {
                throw new IOException(string2);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void b(String ... stringArray) {
        String string = this.c(stringArray);
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("google.messenger", (Parcelable)this.eo);
        this.b(intent);
        intent.putExtra("sender", string);
        this.ek.startService(intent);
    }

    public String register(String ... senderIds) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.em.clear();
        this.b(senderIds);
        try {
            Intent intent = this.em.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string = intent.getStringExtra("registration_id");
            if (string != null) {
                return string;
            }
            String string2 = intent.getStringExtra("error");
            String string3 = intent.getStringExtra("error");
            if (string3 != null) {
                throw new IOException(string3);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void ax() {
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage("com.google.android.gms");
        this.em.clear();
        intent.putExtra("google.messenger", (Parcelable)this.eo);
        this.b(intent);
        this.ek.startService(intent);
    }

    String c(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append(',').append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void b(Intent intent) {
        if (this.el == null) {
            this.el = PendingIntent.getBroadcast((Context)this.ek, (int)0, (Intent)new Intent(), (int)0);
        }
        intent.putExtra("app", (Parcelable)this.el);
    }

    synchronized void ay() {
        if (this.el != null) {
            this.el.cancel();
            this.el = null;
        }
    }
}

