/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.internal.ax;
import com.google.android.gms.internal.w;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
implements Room {
    private final String cY;
    private final String eh;
    private final long dK;
    private final int ei;
    private final String ck;
    private final int eb;
    private final Bundle ed;
    private final ArrayList<Participant> dN;
    public static final Parcelable.Creator<RoomEntity> CREATOR = new Parcelable.Creator<RoomEntity>(){

        public RoomEntity s(Parcel parcel) {
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            String string4 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(string2, string3, l2, n2, string4, n3, bundle, arrayList);
        }

        public RoomEntity[] G(int n2) {
            return new RoomEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.G(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.s(x0);
        }
    };

    public RoomEntity(Room room) {
        this.cY = room.getRoomId();
        this.eh = room.getCreatorId();
        this.dK = room.getCreationTimestamp();
        this.ei = room.getStatus();
        this.ck = room.getDescription();
        this.eb = room.getVariant();
        this.ed = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.dN = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dN.add((Participant)((Participant)arrayList.get(i2)).freeze());
        }
    }

    @Override
    public String getRoomId() {
        return this.cY;
    }

    @Override
    public String getCreatorId() {
        return this.eh;
    }

    @Override
    public long getCreationTimestamp() {
        return this.dK;
    }

    @Override
    public int getStatus() {
        return this.ei;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        int n2 = this.dN.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.dN.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.ck;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ax.b(this.ck, dataOut);
    }

    @Override
    public int getVariant() {
        return this.eb;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.ed;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.dN;
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        int n2 = this.dN.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.dN.get(i2).getParticipantId());
        }
        return arrayList;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string2 = null;
        int n2 = this.dN.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.dN.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    @Override
    public Room freeze() {
        return this;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    public static int a(Room room) {
        return w.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    public static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return w.a(room2.getRoomId(), room.getRoomId()) && w.a(room2.getCreatorId(), room.getCreatorId()) && w.a(room2.getCreationTimestamp(), room.getCreationTimestamp()) && w.a(room2.getStatus(), room.getStatus()) && w.a(room2.getDescription(), room.getDescription()) && w.a(room2.getVariant(), room.getVariant()) && w.a(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && w.a(room2.getParticipants(), room.getParticipants());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    public static String b(Room room) {
        return w.c(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private RoomEntity(String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<Participant> participants) {
        this.cY = roomId;
        this.eh = creatorId;
        this.dK = creationTimestamp;
        this.ei = roomStatus;
        this.ck = description;
        this.eb = variant;
        this.ed = autoMatchCriteria;
        this.dN = participants;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cY);
        dest.writeString(this.eh);
        dest.writeLong(this.dK);
        dest.writeInt(this.ei);
        dest.writeString(this.ck);
        dest.writeInt(this.eb);
        dest.writeBundle(this.ed);
        int n2 = this.dN.size();
        dest.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dN.get(i2).writeToParcel(dest, flags);
        }
    }
}

