/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.x;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener dY;
    private final RoomStatusUpdateListener dZ;
    private final RealTimeMessageReceivedListener ea;
    private final String dJ;
    private final int eb;
    private final String[] ec;
    private final Bundle ed;
    private final boolean ee;

    private RoomConfig(Builder builder) {
        this.dY = builder.dY;
        this.dZ = builder.dZ;
        this.ea = builder.ea;
        this.dJ = builder.ef;
        this.eb = builder.eb;
        this.ed = builder.ed;
        this.ee = builder.ee;
        int n2 = builder.eg.size();
        this.ec = builder.eg.toArray(new String[n2]);
        if (this.ea == null) {
            x.a(this.ee, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.dY;
    }

    public String getInvitationId() {
        return this.dJ;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.dZ;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.ea;
    }

    public int getVariant() {
        return this.eb;
    }

    public String[] getInvitedPlayerIds() {
        return this.ec;
    }

    public Bundle getAutoMatchCriteria() {
        return this.ed;
    }

    public boolean isSocketEnabled() {
        return this.ee;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener dY;
        RoomStatusUpdateListener dZ;
        RealTimeMessageReceivedListener ea;
        String ef = null;
        int eb = -1;
        ArrayList<String> eg = new ArrayList();
        Bundle ed;
        boolean ee = false;

        private Builder(RoomUpdateListener updateListener) {
            this.dY = x.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            x.d(invitationId);
            this.ef = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.dZ = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.ea = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            x.d(playerIds);
            this.eg.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            x.d(playerIds);
            this.eg.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            this.eb = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.ee = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.ed = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

