/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.internal.ax;
import com.google.android.gms.internal.w;

public final class ParticipantEntity
implements Parcelable,
Participant {
    private final PlayerEntity dQ;
    private final String dq;
    private final String bp;
    private final Uri cm;
    private final Uri cn;
    private final int dR;
    private final String dS;
    private final boolean dT;
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new Parcelable.Creator<ParticipantEntity>(){

        public ParticipantEntity q(Parcel parcel) {
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string2, string3, uri, uri2, n2, string6, bl2, playerEntity);
        }

        public ParticipantEntity[] E(int n2) {
            return new ParticipantEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.E(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.q(x0);
        }
    };

    public ParticipantEntity(Participant participant) {
        Player player = participant.getPlayer();
        this.dQ = player == null ? null : new PlayerEntity(player);
        this.dq = participant.getParticipantId();
        this.bp = participant.getDisplayName();
        this.cm = participant.getIconImageUri();
        this.cn = participant.getHiResImageUri();
        this.dR = participant.getStatus();
        this.dS = participant.getClientAddress();
        this.dT = participant.isConnectedToRoom();
    }

    public int getStatus() {
        return this.dR;
    }

    public String getClientAddress() {
        return this.dS;
    }

    public boolean isConnectedToRoom() {
        return this.dT;
    }

    public String getDisplayName() {
        if (this.dQ == null) {
            return this.bp;
        }
        return this.dQ.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.dQ == null) {
            ax.b(this.bp, dataOut);
            return;
        }
        this.dQ.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.dQ == null) {
            return this.cm;
        }
        return this.dQ.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.dQ == null) {
            return this.cn;
        }
        return this.dQ.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.dq;
    }

    public Player getPlayer() {
        return this.dQ;
    }

    public Participant freeze() {
        return this;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    public static int a(Participant participant) {
        return w.hashCode(participant.getPlayer(), participant.getStatus(), participant.getClientAddress(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    public static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return w.a(participant2.getPlayer(), participant.getPlayer()) && w.a(participant2.getStatus(), participant.getStatus()) && w.a(participant2.getClientAddress(), participant.getClientAddress()) && w.a(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && w.a(participant2.getDisplayName(), participant.getDisplayName()) && w.a(participant2.getIconImageUri(), participant.getIconImageUri()) && w.a(participant2.getHiResImageUri(), participant.getHiResImageUri());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    public static String b(Participant participant) {
        return w.c(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.getClientAddress()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private ParticipantEntity(String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player) {
        this.dq = participantId;
        this.bp = displayName;
        this.cm = iconImageUri;
        this.cn = hiResImageUri;
        this.dR = status;
        this.dS = clientAddress;
        this.dT = connectedToRoom;
        this.dQ = player;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.dq);
        dest.writeString(this.bp);
        dest.writeString(this.cm == null ? null : this.cm.toString());
        dest.writeString(this.cn == null ? null : this.cn.toString());
        dest.writeInt(this.dR);
        dest.writeString(this.dS);
        dest.writeInt(this.dT ? 1 : 0);
        dest.writeInt(this.dQ == null ? 0 : 1);
        if (this.dQ != null) {
            this.dQ.writeToParcel(dest, flags);
        }
    }
}

