/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.x;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
implements Invitation {
    private final GameEntity dI;
    private final String dJ;
    private final long dK;
    private final int dL;
    private final Participant dM;
    private final ArrayList<Participant> dN;
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new Parcelable.Creator<InvitationEntity>(){

        public InvitationEntity p(Parcel parcel) {
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            Participant participant = (Participant)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string2, l2, n2, participant, arrayList);
        }

        public InvitationEntity[] D(int n2) {
            return new InvitationEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.D(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.p(x0);
        }
    };

    public InvitationEntity(Invitation invitation) {
        this.dI = new GameEntity(invitation.getGame());
        this.dJ = invitation.getInvitationId();
        this.dK = invitation.getCreationTimestamp();
        this.dL = invitation.getInvitationType();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.dN = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.dN.add((Participant)participant2.freeze());
        }
        x.b(participant, (Object)"Must have a valid inviter!");
        this.dM = (Participant)participant.freeze();
    }

    @Override
    public Game getGame() {
        return this.dI;
    }

    @Override
    public String getInvitationId() {
        return this.dJ;
    }

    @Override
    public Participant getInviter() {
        return this.dM;
    }

    @Override
    public long getCreationTimestamp() {
        return this.dK;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.dN;
    }

    @Override
    public int getInvitationType() {
        return this.dL;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    public static int a(Invitation invitation) {
        return w.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    public static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return w.a(invitation2.getGame(), invitation.getGame()) && w.a(invitation2.getInvitationId(), invitation.getInvitationId()) && w.a(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && w.a(invitation2.getInvitationType(), invitation.getInvitationType()) && w.a(invitation2.getInviter(), invitation.getInviter()) && w.a(invitation2.getParticipants(), invitation.getParticipants());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    public static String b(Invitation invitation) {
        return w.c(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private InvitationEntity(GameEntity game, String invitationId, long creationTimestamp, int invitationType, Participant inviter, ArrayList<Participant> participants) {
        this.dI = game;
        this.dJ = invitationId;
        this.dK = creationTimestamp;
        this.dL = invitationType;
        this.dM = inviter;
        this.dN = participants;
    }

    public void writeToParcel(Parcel dest, int flags) {
        this.dI.writeToParcel(dest, flags);
        dest.writeString(this.dJ);
        dest.writeLong(this.dK);
        dest.writeInt(this.dL);
        this.dM.writeToParcel(dest, flags);
        int n2 = this.dN.size();
        dest.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dN.get(i2).writeToParcel(dest, flags);
        }
    }
}

