/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.internal.af;
import com.google.android.gms.internal.ba;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ImageManager {
    private static ImageManager ai;
    private final Context mContext;
    private final af<Uri, WeakReference<Drawable.ConstantState>> aj;
    private final Map<d, b> ak;
    private final Map<Uri, b> al;

    public static ImageManager create(Context context) {
        if (ai == null) {
            ai = new ImageManager(context);
        }
        return ai;
    }

    private ImageManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.aj = new af(50);
        if (ba.ad()) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.aj));
        }
        this.ak = new HashMap<d, b>();
        this.al = new HashMap<Uri, b>();
    }

    public void loadImage(ImageView imageView, Uri uri) {
        this.loadImage(imageView, uri, 0);
    }

    public void loadImage(ImageView imageView, int resId) {
        this.loadImage(imageView, null, resId);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        this.a(new c(imageView, defaultResId), uri);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        this.loadImage(listener, uri, 0);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        this.a(new a(listener, defaultResId), uri);
    }

    private void a(d d2, Uri uri) {
        Drawable.ConstantState constantState;
        Object object;
        if (uri != null && (object = this.aj.get(uri)) != null && (constantState = (Drawable.ConstantState)object.get()) != null) {
            d2.a(uri, constantState.newDrawable());
            return;
        }
        if (!d2.a(uri)) {
            return;
        }
        object = this.al.get(uri);
        if (object == null) {
            object = new b(uri);
            this.al.put(uri, (b)((Object)object));
        }
        ((b)((Object)object)).a(d2);
        this.ak.put(d2, (b)((Object)object));
        constantState = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
        constantState.putExtra("com.google.android.gms.extras.uri", (Parcelable)uri);
        constantState.putExtra("com.google.android.gms.extras.resultReceiver", object);
        constantState.putExtra("com.google.android.gms.extras.priority", 3);
        this.mContext.sendBroadcast((Intent)constantState);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class e
    implements ComponentCallbacks2 {
        private final af<Uri, WeakReference<Drawable.ConstantState>> as;

        public e(af<Uri, WeakReference<Drawable.ConstantState>> af2) {
            this.as = af2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.as.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.as.evictAll();
            } else if (level >= 40) {
                this.as.trimToSize(this.as.size() / 2);
            }
        }
    }

    final class c
    extends d {
        private final WeakReference<ImageView> ap;

        private c(ImageView imageView, int n2) {
            super(imageView.hashCode(), n2);
            this.ap = new WeakReference<ImageView>(imageView);
        }

        public void a(Uri uri, Drawable drawable2) {
            b b2;
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView != null) {
                imageView.setImageDrawable(drawable2);
            }
            if ((b2 = (b)((Object)ImageManager.this.ak.remove(this))) != null) {
                b2.b(this);
            }
        }

        public boolean a(Uri uri) {
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView != null) {
                if (this.ar == 0) {
                    imageView.setImageDrawable(null);
                } else {
                    imageView.setImageResource(this.ar);
                }
            }
            if (uri == null) {
                b b2 = (b)((Object)ImageManager.this.ak.remove(this));
                if (b2 != null) {
                    b2.b(this);
                }
                return false;
            }
            return true;
        }

        public void onImageLoaded(Uri uri, Drawable drawable2) {
            b b2 = (b)((Object)ImageManager.this.ak.remove(this));
            ImageView imageView = (ImageView)this.ap.get();
            if (imageView == null) {
                return;
            }
            if (b2 != null && b2.getUri().equals((Object)uri)) {
                imageView.setImageDrawable(drawable2);
            }
        }

        public boolean equals(Object o2) {
            if (o2 instanceof c) {
                c c2 = (c)o2;
                return this.ap != null && c2.ap != null && this.aq == c2.aq;
            }
            return false;
        }
    }

    final class a
    extends d {
        private final WeakReference<OnImageLoadedListener> am;

        private a(OnImageLoadedListener onImageLoadedListener, int n2) {
            super(onImageLoadedListener.hashCode(), n2);
            this.am = new WeakReference<OnImageLoadedListener>(onImageLoadedListener);
        }

        public void a(Uri uri, Drawable drawable2) {
            OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
            if (onImageLoadedListener != null) {
                onImageLoadedListener.onImageLoaded(uri, drawable2);
            }
        }

        public boolean a(Uri uri) {
            if (uri == null) {
                OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
                if (onImageLoadedListener != null) {
                    if (this.ar == 0) {
                        onImageLoadedListener.onImageLoaded(uri, null);
                    } else {
                        onImageLoadedListener.onImageLoaded(uri, ImageManager.this.mContext.getResources().getDrawable(this.ar));
                    }
                }
                return false;
            }
            return true;
        }

        public void onImageLoaded(Uri uri, Drawable drawable2) {
            b b2 = (b)((Object)ImageManager.this.ak.remove(this));
            OnImageLoadedListener onImageLoadedListener = (OnImageLoadedListener)this.am.get();
            if (onImageLoadedListener != null) {
                onImageLoadedListener.onImageLoaded(uri, drawable2);
            }
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                a a2 = (a)o2;
                return this.am != null && a2.am != null && this.aq == a2.aq;
            }
            return false;
        }
    }

    abstract class d
    implements OnImageLoadedListener {
        protected final int aq;
        protected final int ar;

        private d(int n2, int n3) {
            this.aq = n2;
            this.ar = n3;
        }

        public abstract void a(Uri var1, Drawable var2);

        public abstract boolean a(Uri var1);

        public abstract void onImageLoaded(Uri var1, Drawable var2);

        public int hashCode() {
            return this.aq;
        }
    }

    public final class b
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<d> ao;

        b(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.ao = new ArrayList();
        }

        public void a(d d2) {
            this.ao.add(d2);
        }

        public void b(d d2) {
            this.ao.remove(d2);
        }

        public Uri getUri() {
            return this.mUri;
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            BitmapDrawable bitmapDrawable = null;
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            if (parcelFileDescriptor != null) {
                Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)parcelFileDescriptor.getFileDescriptor());
                try {
                    parcelFileDescriptor.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
                bitmapDrawable = new BitmapDrawable(ImageManager.this.mContext.getResources(), bitmap);
                ImageManager.this.aj.put(this.mUri, new WeakReference<Drawable.ConstantState>(bitmapDrawable.getConstantState()));
            }
            ImageManager.this.al.remove(this.mUri);
            int n2 = this.ao.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.ao.get(i2).onImageLoaded(this.mUri, (Drawable)bitmapDrawable);
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2);
    }
}

