/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.internal.ba;
import com.google.android.gms.internal.o;
import com.google.android.gms.internal.r;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Scanner;

public final class GooglePlayServicesUtil {
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 3159100;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    private static final byte[][] C = new byte[][]{Base64.decode((String)"MIIEQzCCAyugAwIBAgIJAMLgh0ZkSjCNMA0GCSqGSIb3DQEBBAUAMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDAeFw0wODA4MjEyMzEzMzRaFw0zNjAxMDcyMzEzMzRaMHQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUgSW5jLjEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBAKtWLgDYO6IIrgqWbxJOKdoR8qtW0I9Y4sypEwPpt1TTcvZApxsdyxMJZ2JORland2qSGT2y5b+3JKkedxiLDmpHpDsz2WCbdxgxRczfey5YZnTJ4VZbH0xqWVW/8lGmPav5xVwnIiJS6HXk+BVKZF+JcWjAsb/GEuq/eFdpuzSqeYTcfi6idkyugwfYwXFU1+5fZKUaRKYCwkkFQVfcAs1fXA5V+++FGfvjJ/CxURaSxaBvGdGDhfXE28LWuT9ozCl5xw4Yq5OGazvV24mZVSoOO0yZ31j7kYvtwYK6NeADwbSxDdJEqO4k//0zOHKrUiGYXtqw/A0LFFtqoZKFjnkCAQOjgdkwgdYwHQYDVR0OBBYEFMd9jMIhF1Ylmn/Tgt9r45jk14alMIGmBgNVHSMEgZ4wgZuAFMd9jMIhF1Ylmn/Tgt9r45jk14aloXikdjB0MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEUMBIGA1UEChMLR29vZ2xlIEluYy4xEDAOBgNVBAsTB0FuZHJvaWQxEDAOBgNVBAMTB0FuZHJvaWSCCQDC4IdGZEowjTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQBt0lLO74UwLDYKqs6Tm8/yzKkEu116FmH4rkaymUIE0P9KaMftGlMexFlaYjzmB2OxZyl6euNXEsQH8gjwyxCUKRJNexBiGcCEyj6z+a1fuHHvkiaai+KL8W1EyNmgjmyy8AW7P+LLlkR+ho5zEHatRbM/YAnqGcFh5iZBqpknHf1SKMXFh4dd239FJ1jWYfbMDMy3NS5CTMQ2XFI1MvcyUTdZPErjQfTbQe3aDQsQcafEQPD+nqActifKZ0Np0IS9L9kR/wbNvyz6ENwPiTrjV2KRkEjH78ZMcUQXg0L3BYHJ3lc69Vs5Ddf9uUGGMYldX3WfMBEmh/9iFBDAaTCK", (int)0), Base64.decode((String)"MIIEqDCCA5CgAwIBAgIJANWFuGx90071MA0GCSqGSIb3DQEBBAUAMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTAeFw0wODA0MTUyMzM2NTZaFw0zNTA5MDEyMzM2NTZaMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBANbOLggKv+IxTdGNs8/TGFy0PTP6DHThvbbR24kT9ixcOd9W+EaBPWW+wPPKQmsHxajtWjmQwWfna8mZuSeJS48LIgAZlKkpFeVyxW0qMBujb8X8ETrWy550NaFtI6t9+u7hZeTfHwqNvacKhp1RbE6dBRGWynwMVX8XW8N1+UjFaq6GCJukT4qmpN2afb8sCjUigq0GuMwYXrFVee74bQgLHWGJwPmvmLHC69EH6kWr22ijx4OKXlSIx2xT1AsSHee70w5iDBiK4aph27yH3TxkXy9V89TDdexAcKk/cVHYNnDBapcavl7y0RiQ4biu8ymM8Ga/nmzhRKya6G0cGw8CAQOjgfwwgfkwHQYDVR0OBBYEFI0cxb6VTEM8YYY6FbBMvAPyT+CyMIHJBgNVHSMEgcEwgb6AFI0cxb6VTEM8YYY6FbBMvAPyT+CyoYGapIGXMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbYIJANWFuGx90071MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBABnTDPEF+3iSP0wNfdIjIz1AlnrPzgAIHVvXxunW7SBrDhEglQZBbKJEk5kT0mtKoOD1JMrSu1xuTKEBahWRbqHsXclaXjoBADb0kkjVEJu/Lh5hgYZnOjvlba8Ld7HCKePCVePoTJBdI4fvugnL8TsgK05aIskyY0hKI9L8KfqfGTl1lzOv2KoWD0KWwtAWPoGChZxmQ+nBli+gwYMzM1vAkP+aayLe0a1EQimlOalO762r0GXO0ks+UeXde2Z4e+8S/pf7pITEI/tP+MxJTALw9QUWEv9lKTk+jkbqxbsh8nfBUapfKqYn0eidpwq2AzVp3juYl7//fKnaPhJD9gs=", (int)0)};
    private static final byte[][] D = new byte[][]{Base64.decode((String)"MIICUjCCAbsCBEk0mH4wDQYJKoZIhvcNAQEEBQAwcDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtHb29nbGUsIEluYzEUMBIGA1UECxMLR29vZ2xlLCBJbmMxEDAOBgNVBAMTB1Vua25vd24wHhcNMDgxMjAyMDIwNzU4WhcNMzYwNDE5MDIwNzU4WjBwMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFjAUBgNVBAcTDU1vdW50YWluIFZpZXcxFDASBgNVBAoTC0dvb2dsZSwgSW5jMRQwEgYDVQQLEwtHb29nbGUsIEluYzEQMA4GA1UEAxMHVW5rbm93bjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAn0gDGZD5sUcmOE4EU9GPjAu/jcd7JQSksSB8TGxEurwArcZhD6a2qy2oDjPy7vFrJqP2uFua+sqQn/u+s/TJT36BIqeY4OunXO090in6c2X0FRZBWqnBYX3Vg84Zuuigu9iF/BeptL0mQIBRIarbk3fetAATOBQYiC7FIoL8WA0CAwEAATANBgkqhkiG9w0BAQQFAAOBgQBAhmae1jHaQ4Td0GHSJuBzuYzEuZ34teS+njy+l1Aeg98cb6lZwM5gXE/SrG0chM7eIEdsurGb6PIgOv93F61lLY/MiQcI0SFtqERXWSZJ4OnTxLtM9Y2hnbHU/EG8uVhPZOZfQQ0FKf1baIOMFB0Km9HbEZHLKg33kOoMsS2zpA==", (int)0), Base64.decode((String)"MIIEqDCCA5CgAwIBAgIJAIR+T/LWtd6OMA0GCSqGSIb3DQEBBQUAMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTAeFw0xMDAxMjAwMTAxMzVaFw0zNzA2MDcwMTAxMzVaMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBANgocXw20RcP1E0Kew8HESboW7/fM7A0YABalMz7ZaXboLJD32Cxkb+dBt8dilwKM+LRY/UT3x0iU0HqPDN5IuhcAuw0ztlMuAcjpiP/S6/7tOXv5nc7PqK+uLyyAmfP54VRH4Mu+YerdZT+HinPvE0IOh8SUgB3c5byFltpewCjoME6zDCKk/IhY8FunD1KshSfNkxFwEMUMnA58doJYJPxs/wYtlYQlcYiX8cQK5h8bxOkXSTj4MVOhZ1n41tnCCcT0tbwV900V9GfxP6N3eyMOk8/lyMFGacKKDY0rDWBo0q9oX2EWgoJhfv4BgsDaid4YIFj+gw3uefyoQ52vHcCAQOjgfwwgfkwHQYDVR0OBBYEFLXH+RJveA06+8plc3M/9SJrmxc3MIHJBgNVHSMEgcEwgb6AFLXH+RJveA06+8plc3M/9SJrmxc3oYGapIGXMIGUMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEQMA4GA1UEChMHQW5kcm9pZDEQMA4GA1UECxMHQW5kcm9pZDEQMA4GA1UEAxMHQW5kcm9pZDEiMCAGCSqGSIb3DQEJARYTYW5kcm9pZEBhbmRyb2lkLmNvbYIJAIR+T/LWtd6OMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEw+p2V9Jua71xEMjxnfH42hCX0zhg9p3r/K20ajfoflsw+7NHscdVW8uzyZVBSARpZfnHkqAtDb5aZHYbN5R6tr/7C6xqLBoM34Yvh3qWcN/W8GLkBuzhgGDGBJjfw2nycRcZjlb8uhUuYFjc6UzlkfxPSpmCszutgZbXdvVbfQGs8x3dcM7LeJeHYGZRD5SaVSSjExs8tlQc+LNUIOvMRSJVmWP0JmaQVyZmJPs5jP21IXiB0RHG4DRhb4USEY0KKmnRPXkvDNEdvVjiODWlSlSsJR59IsRGo/7hQSEOlER0tAYwe7JoQrT2vTVYIcc5ZR/6JgWwXiJJXXFdh6kfY=", (int)0)};
    private static final byte[][] E = new byte[][]{Base64.decode((String)"MIICpzCCAmWgAwIBAgIEUAV8QjALBgcqhkjOOAQDBQAwNzELMAkGA1UEBhMCVVMxEDAOBgNVBAoTB0FuZHJvaWQxFjAUBgNVBAMTDUFuZHJvaWQgRGVidWcwHhcNMTIwNzE3MTQ1MjUwWhcNMjIwNzE1MTQ1MjUwWjA3MQswCQYDVQQGEwJVUzEQMA4GA1UEChMHQW5kcm9pZDEWMBQGA1UEAxMNQW5kcm9pZCBEZWJ1ZzCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GEAAKBgGrRG9fVZtJ69DnALkForP1FtL6FvJmMe5uOHHdUaT+MDUKKpPzhEISBOEJPpozRMFJO7/bxNzhjgi+mNymL/k1GoLhmZe7wQRc5AQNbHIBqoxgYDTA6qMyeWSPgam+r+nVoPEU7sgd3fPL958+xmxQwOBSqHfe0PVsiK1cGtIuUMAsGByqGSM44BAMFAAMvADAsAhQJ0tGwRwIptb7SkCZh0RLycMXmHQIUZ1ACBqeAULp4rscXTxYEf4Tqovc=", (int)0)};
    private static final byte[][] F = GooglePlayServicesUtil.a(C, D, E);
    private static final byte[][] G = new byte[][]{Base64.decode((String)"MIICXzCCAcigAwIBAgIESxmxnTANBgkqhkiG9w0BAQUFADB0MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEVMBMGA1UEChMMR29vZ2xlLCBJbmMuMRAwDgYDVQQLEwdVbmtub3duMQ8wDQYDVQQDEwZCYXphYXIwHhcNMDkxMjA1MDEwNDI5WhcNMzcwNDIyMDEwNDI5WjB0MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEVMBMGA1UEChMMR29vZ2xlLCBJbmMuMRAwDgYDVQQLEwdVbmtub3duMQ8wDQYDVQQDEwZCYXphYXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKkIiN6W4zU0dwndSyUeeimoRzdrLly6W1vVBD6DiAECmBkUlBP6M6rlRDsDU0rOSq1vUJcSSdmOdqOafkzM4dcbp74+dWdNtfEHWphzcAFGSKfOcDwtx4g0iQWSEq+cbFsoq9VPg2QRyDGin1APKALRbObRhW+GcKr8omVBg3s5AgMBAAEwDQYJKoZIhvcNAQEFBQADgYEASYTG80FHASNiOidP6eE3PXUxzA386adq5n/7cFtATL0bwRaMqxi7EcN4lb+082zBTOwdLMVRag7O1AdOtWiCiVBkAK/43MjvVAQSAv3v8f2C4PMjEHL9zN5KNovgxsP5uLOqDWg8Or/amre7iDLpvl42GbqS3TrMA2qttaYZr1A=", (int)0)};
    public static boolean H = false;
    public static boolean I = false;
    static boolean J = false;

    private GooglePlayServicesUtil() {
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
        }
        return "UNKNOWN_ERROR_CODE";
    }

    public static int isGooglePlayServicesAvailable(Context context) {
        ApplicationInfo applicationInfo;
        PackageInfo packageInfo;
        PackageInfo packageInfo2;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is missing.");
            return 1;
        }
        byte[] byArray = GooglePlayServicesUtil.a(packageInfo2, C);
        if (byArray == null) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
            return 9;
        }
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        if (GooglePlayServicesUtil.a(packageInfo, (byte[][])new byte[][]{byArray}) == null) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
            return 9;
        }
        if (packageInfo.versionCode < 3159100) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires 3159100 but found " + packageInfo.versionCode));
            return 2;
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.");
            nameNotFoundException.printStackTrace();
            return 1;
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    private static byte[] a(PackageInfo packageInfo, byte[] ... byArray) {
        X509Certificate x509Certificate;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException certificateException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Could not get certificate instance.");
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Package has more than one signature.");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(packageInfo.signatures[0].toByteArray());
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Could not generate certificate.");
            return null;
        }
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Certificate has expired.");
            return null;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Certificate is not yet valid.");
            return null;
        }
        byte[] byArray2 = packageInfo.signatures[0].toByteArray();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte[] byArray3 = byArray[i2];
            if (!Arrays.equals(byArray3, byArray2)) continue;
            return byArray3;
        }
        if (Log.isLoggable((String)"GooglePlayServicesUtil", (int)2)) {
            Log.v((String)"GooglePlayServicesUtil", (String)("Signature not valid.  Found: \n" + Base64.encodeToString((byte[])byArray2, (int)0)));
        }
        return null;
    }

    public static Intent a(Context context, int n2, int n3) {
        switch (n2) {
            case 1: 
            case 2: {
                if (GooglePlayServicesUtil.b(n3)) {
                    if (GooglePlayServicesUtil.c(context)) {
                        return r.h(GOOGLE_PLAY_SERVICES_PACKAGE);
                    }
                    return r.g("com.google.android.apps.bazaar");
                }
                return r.g(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 3: {
                return r.e(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    static boolean b(int n2) {
        switch (GooglePlayServicesUtil.c(n2)) {
            case 0: {
                return !GooglePlayServicesUtil.f();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private static int c(int n2) {
        if (n2 == -1) {
            return 2;
        }
        return n2;
    }

    private static boolean f() {
        if (H) {
            return I;
        }
        return "user".equals(Build.TYPE);
    }

    private static boolean c(Context context) {
        if (H) {
            return J;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo("com.google.android.apps.bazaar", 64);
            return GooglePlayServicesUtil.a(packageInfo, G) != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static String b(Context context, int n2, int n3) {
        Resources resources = context.getResources();
        String string2 = resources.getString(R.string.common_google_play_services_unknown_issue);
        switch (n2) {
            case 1: {
                string2 = GooglePlayServicesUtil.a(context.getResources()) ? resources.getString(R.string.common_google_play_services_install_text_tablet) : resources.getString(R.string.common_google_play_services_install_text_phone);
                if (!GooglePlayServicesUtil.b(n3)) break;
                string2 = string2 + " (via Bazaar)";
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_text);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_update_text);
                if (!GooglePlayServicesUtil.b(n3)) break;
                string2 = string2 + " (via Bazaar)";
                break;
            }
            case 9: {
                string2 = resources.getString(R.string.common_google_play_services_unsupported_text);
            }
        }
        return string2;
    }

    public static String a(Context context, int n2) {
        Resources resources = context.getResources();
        String string2 = null;
        switch (n2) {
            case 1: {
                string2 = resources.getString(R.string.common_google_play_services_install_button);
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_button);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_update_button);
                break;
            }
            case 9: {
                string2 = resources.getString(17039370);
            }
        }
        return string2;
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.a(errorCode, activity, requestCode, null, -1);
    }

    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        Intent intent = GooglePlayServicesUtil.a(context, errorCode, -1);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)0x10000000);
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.a(errorCode, activity, requestCode, cancelListener, -1);
    }

    public static Dialog a(int n2, Activity activity, int n3, DialogInterface.OnCancelListener onCancelListener, int n4) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity).setMessage((CharSequence)GooglePlayServicesUtil.b((Context)activity, n2, n4));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        Intent intent = GooglePlayServicesUtil.a((Context)activity, n2, n4);
        o o2 = new o(activity, intent, n3);
        String string2 = GooglePlayServicesUtil.a((Context)activity, n2);
        if (string2 != null) {
            builder.setPositiveButton((CharSequence)string2, (DialogInterface.OnClickListener)o2);
        }
        switch (n2) {
            case 0: 
            case 4: 
            case 6: {
                return null;
            }
            case 1: {
                return builder.setTitle(R.string.common_google_play_services_install_title).create();
            }
            case 3: {
                return builder.setTitle(R.string.common_google_play_services_enable_title).create();
            }
            case 2: {
                return builder.setTitle(R.string.common_google_play_services_update_title).create();
            }
            case 9: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Google Play services is invalid. Cannot recover.");
                return builder.setTitle(R.string.common_google_play_services_unsupported_title).create();
            }
            case 7: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Network error occurred. Please retry request later.");
                return null;
            }
            case 8: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Internal error occurred. Please see logs for detailed information");
                return null;
            }
            case 10: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Developer error occurred. Please see logs for detailed information");
                return null;
            }
            case 5: {
                Log.e((String)"GooglePlayServicesUtil", (String)"An invalid account was specified when connecting. Please provide a valid account.");
                return null;
            }
            case 11: {
                Log.e((String)"GooglePlayServicesUtil", (String)"The application is not licensed to the user.");
                return null;
            }
        }
        Log.e((String)"GooglePlayServicesUtil", (String)("Unexpected error code " + n2));
        return null;
    }

    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static boolean a(Resources resources) {
        boolean bl2 = (resources.getConfiguration().screenLayout & 0xF) > 3;
        return ba.aa() && bl2 || GooglePlayServicesUtil.b(resources);
    }

    private static boolean b(Resources resources) {
        Configuration configuration = resources.getConfiguration();
        if (ba.ac()) {
            return (configuration.screenLayout & 0xF) <= 3 && configuration.smallestScreenWidthDp >= 600;
        }
        return false;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static byte[][] a(byte[][] ... byArray) {
        int n2 = 0;
        for (byte[][] byArray2 : byArray) {
            n2 += byArray2.length;
        }
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        for (byte[][] byArray3 : byArray) {
            for (int i2 = 0; i2 < byArray3.length; ++i2) {
                byArrayArray[n3++] = byArray3[i2];
            }
        }
        return byArrayArray;
    }
}

