/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.AccountManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.a;
import com.google.android.gms.internal.h;
import java.io.IOException;
import java.net.URISyntaxException;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_HANDLE_NOTIFICATION = "handle_notification";
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    private static final ComponentName w = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName x = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");
    private static final Intent y = new Intent().setComponent(w);
    private static final Intent z = new Intent().setComponent(x);

    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, accountName, scope, new Bundle());
    }

    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        h h2;
        Context context2 = context.getApplicationContext();
        GoogleAuthUtil.b(context2);
        GoogleAuthUtil.a(context2);
        extras = extras == null ? new Bundle() : new Bundle(extras);
        if (!extras.containsKey("androidPackageName")) {
            extras.putString("androidPackageName", context.getPackageName());
        }
        if (context.bindService(y, (ServiceConnection)(h2 = new h()), 1)) {
            try {
                a a2 = a.a.a(h2.d());
                Bundle bundle = a2.a(accountName, scope, extras);
                String string2 = bundle.getString("authtoken");
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    String string3 = string2;
                    return string3;
                }
                try {
                    String string4 = bundle.getString("Error");
                    Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                    if (GoogleAuthUtil.b(string4)) {
                        throw new UserRecoverableAuthException(string4, intent);
                    }
                    if (GoogleAuthUtil.a(string4)) {
                        throw new IOException(string4);
                    }
                    throw new GoogleAuthException(string4);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
            }
            finally {
                context.unbindService((ServiceConnection)h2);
            }
        }
        throw new UserRecoverableAuthException("AppDownloadRequired", null);
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putBoolean(KEY_HANDLE_NOTIFICATION, true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.a(callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean(KEY_HANDLE_NOTIFICATION, true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new IllegalArgumentException("Authority cannot be empty or null.");
        }
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean(KEY_HANDLE_NOTIFICATION, true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    private static void a(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callack cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static String a(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            return GoogleAuthUtil.getToken(context, string2, string3, bundle);
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n2 = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            PendingIntent pendingIntent = GooglePlayServicesUtil.getErrorPendingIntent(n2, context, 0);
            Resources resources = context.getResources();
            String string4 = resources.getString(R.string.auth_client_play_services_err_notification_msg);
            Notification notification = new Notification(17301642, (CharSequence)string4, System.currentTimeMillis());
            notification.flags |= 0x10;
            String string5 = context.getApplicationInfo().name;
            if (TextUtils.isEmpty((CharSequence)string5)) {
                string5 = context.getPackageName();
            }
            String string6 = resources.getString(R.string.auth_client_requested_by_msg, new Object[]{string5});
            int n3 = 0;
            switch (googlePlayServicesAvailabilityException.getConnectionStatusCode()) {
                case 1: {
                    n3 = R.string.auth_client_needs_installation_title;
                    break;
                }
                case 2: {
                    n3 = R.string.auth_client_needs_update_title;
                    break;
                }
                case 3: {
                    n3 = R.string.auth_client_needs_enabling_title;
                    break;
                }
                default: {
                    n3 = R.string.auth_client_using_bad_version_title;
                }
            }
            String string7 = resources.getString(n3);
            notification.setLatestEventInfo(context, (CharSequence)string7, (CharSequence)string6, pendingIntent);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.notify(39789, notification);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static void a(Context context) throws GooglePlayServicesAvailabilityException, GoogleAuthException {
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        if (n2 != 0) {
            Intent intent = GooglePlayServicesUtil.a(context, n2, -1);
            String string2 = "GooglePlayServices not available due to error " + n2;
            Log.e((String)"GoogleAuthUtil", (String)string2);
            if (intent == null) {
                throw new GoogleAuthException(string2);
            }
            throw new GooglePlayServicesAvailabilityException(n2, "GooglePlayServicesNotAvailable", intent);
        }
    }

    private static void b(Context context) {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == context.getMainLooper()) {
            IllegalStateException illegalStateException = new IllegalStateException("calling this from your main thread can lead to deadlock");
            Log.e((String)"GoogleAuthUtil", (String)"Calling this from your main thread can lead to deadlock and/or ANRs", (Throwable)illegalStateException);
            throw illegalStateException;
        }
    }

    private static boolean a(String string2) {
        return "NetworkError".equals(string2) || "ServiceUnavailable".equals(string2) || "Timeout".equals(string2);
    }

    private static boolean b(String string2) {
        return "BadAuthentication".equals(string2) || "CaptchaRequired".equals(string2) || "DeviceManagementRequiredOrSyncDisabled".equals(string2) || "NeedPermission".equals(string2) || "NeedsBrowser".equals(string2) || "UserCancel".equals(string2) || "AppDownloadRequired".equals(string2);
    }

    private GoogleAuthUtil() {
    }
}

