/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cs;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest FE;
    private final DataMap FD;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.FE = putDataRequest;
        this.FD = new DataMap();
        if (dataMap != null) {
            this.FD.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.d(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.FE.getUri();
    }

    public DataMap getDataMap() {
        return this.FD;
    }

    public PutDataRequest asPutDataRequest() {
        ci.a a2 = ci.a(this.FD);
        this.FE.setData(cs.f(a2.GO));
        int n2 = a2.GP.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = Integer.toString(i2);
            Asset asset = a2.GP.get(i2);
            if (string2 == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string2);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string2 + " " + asset));
            }
            this.FE.putAsset(string2, asset);
        }
        return this.FE;
    }
}

