/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.cr;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap FD;

    public static DataMapItem fromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            throw new IllegalStateException("provided dataItem is null");
        }
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem source) {
        this.mUri = source.getUri();
        this.FD = this.a((DataItem)source.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.FD;
    }

    private DataMap a(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n2 = dataItem.getAssets().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataItemAsset dataItemAsset = dataItem.getAssets().get(Integer.toString(i2));
                if (dataItemAsset == null) {
                    throw new IllegalStateException("Cannot find DataItemAsset referenced in data at " + i2 + " for " + dataItem);
                }
                Asset asset = Asset.createFromRef(dataItemAsset.getId());
                arrayList.add(asset);
            }
            ci.a a2 = new ci.a(cj.i(dataItem.getData()), arrayList);
            return ci.a(a2);
        }
        catch (cr cr2) {
            throw new IllegalStateException("Unable to parse. Not a DataItem.");
        }
    }
}

