/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.ch;
import com.google.android.gms.internal.cs;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cq
implements o.f {
    private final Context mContext;
    private final String Ba;
    private final ExecutorService DC;
    private bg<ch.a> Dv;

    cq(Context context, String string2) {
        this.mContext = context;
        this.Ba = string2;
        this.DC = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<ch.a> bg2) {
        this.Dv = bg2;
    }

    @Override
    public void eM() {
        this.DC.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.fB();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fB() {
        if (this.Dv == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.Dv.eL();
        bh.o("Attempting to load resource from disk");
        if ((ce.ft().fu() == ce.a.Dk || ce.ft().fu() == ce.a.Dl) && this.Ba.equals(ce.ft().getContainerId())) {
            this.Dv.a(bg.a.CO);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fC());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.ak("Failed to find the resource in the disk");
            this.Dv.a(bg.a.CO);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(fileInputStream, byteArrayOutputStream);
            ch.a a2 = ch.a.g(byteArrayOutputStream.toByteArray());
            this.d(a2);
            this.Dv.h(a2);
        }
        catch (IOException iOException) {
            this.Dv.a(bg.a.CP);
            bh.p("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.Dv.a(bg.a.CP);
            bh.p("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.p("Error closing stream for reading resource from disk");
            }
        }
        bh.o("The Disk resource was successfully read.");
    }

    @Override
    public void b(final ch.a a2) {
        this.DC.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.c(a2);
            }
        });
    }

    @Override
    public cr.c bx(int n2) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.p("Failed to load the container. No default container resource found with the resource ID " + n2);
            return null;
        }
        bh.o("Attempting to load a container from the resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(inputStream, byteArrayOutputStream);
            cr.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                bh.o("The container was successfully loaded from the resource (using JSON file format)");
                return c2;
            }
            return this.f(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.p("Error reading the default container with resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
            return null;
        }
    }

    private cr.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return ba.as(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.ak("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            bh.p("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cr.c f(byte[] byArray) {
        try {
            cr.c c2 = cr.b(c.f.a(byArray));
            if (c2 != null) {
                bh.o("The container was successfully loaded from the resource (using binary file)");
            }
            return c2;
        }
        catch (com.google.android.gms.internal.cr cr2) {
            bh.m("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (cr.g g2) {
            bh.p("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.DC.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(ch.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.fC();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.m("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(cs.f(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.p("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.p("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File fC() {
        String string2 = "resource_" + this.Ba;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string2);
    }

    private void d(ch.a a2) throws IllegalArgumentException {
        if (a2.fY == null && a2.Fu == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

