/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.m;
import com.google.android.gms.maps.model.n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final m CREATOR = new m();
    private final int nZ;
    private final List<LatLng> Au;
    private final List<List<LatLng>> Av;
    private float zQ = 10.0f;
    private int zR = -16777216;
    private int zS = 0;
    private float zT = 0.0f;
    private boolean zU = true;
    private boolean Aw = false;

    public PolygonOptions() {
        this.nZ = 1;
        this.Au = new ArrayList<LatLng>();
        this.Av = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.nZ = versionCode;
        this.Au = points;
        this.Av = holes;
        this.zQ = strokeWidth;
        this.zR = strokeColor;
        this.zS = fillColor;
        this.zT = zIndex;
        this.zU = visible;
        this.Aw = geodesic;
    }

    int getVersionCode() {
        return this.nZ;
    }

    List eq() {
        return this.Av;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.em()) {
            n.a(this, out, flags);
        } else {
            m.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.Au.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.Au.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Au.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.Av.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zQ = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zR = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zS = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zT = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zU = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.Aw = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Au;
    }

    public List<List<LatLng>> getHoles() {
        return this.Av;
    }

    public float getStrokeWidth() {
        return this.zQ;
    }

    public int getStrokeColor() {
        return this.zR;
    }

    public int getFillColor() {
        return this.zS;
    }

    public float getZIndex() {
        return this.zT;
    }

    public boolean isVisible() {
        return this.zU;
    }

    public boolean isGeodesic() {
        return this.Aw;
    }
}

