/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.maps.internal.p;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.StreetViewPanoramaCamera;
import com.google.android.gms.maps.model.StreetViewPanoramaLocation;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;

public interface IStreetViewPanoramaDelegate
extends IInterface {
    public void enableZoom(boolean var1) throws RemoteException;

    public void enablePanning(boolean var1) throws RemoteException;

    public void enableUserNavigation(boolean var1) throws RemoteException;

    public void enableStreetNames(boolean var1) throws RemoteException;

    public boolean isZoomGesturesEnabled() throws RemoteException;

    public boolean isPanningGesturesEnabled() throws RemoteException;

    public boolean isUserNavigationEnabled() throws RemoteException;

    public boolean isStreetNamesEnabled() throws RemoteException;

    public void animateTo(StreetViewPanoramaCamera var1, long var2) throws RemoteException;

    public StreetViewPanoramaCamera getPanoramaCamera() throws RemoteException;

    public void setPositionWithID(String var1) throws RemoteException;

    public void setPosition(LatLng var1) throws RemoteException;

    public void setPositionWithRadius(LatLng var1, int var2) throws RemoteException;

    public StreetViewPanoramaLocation getStreetViewPanoramaLocation() throws RemoteException;

    public void setOnStreetViewPanoramaChangeListener(q var1) throws RemoteException;

    public void setOnStreetViewPanoramaCameraChangeListener(p var1) throws RemoteException;

    public void setOnStreetViewPanoramaClickListener(r var1) throws RemoteException;

    public StreetViewPanoramaOrientation pointToOrientation(b var1) throws RemoteException;

    public b orientationToPoint(StreetViewPanoramaOrientation var1) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate$a
    extends Binder
    implements IStreetViewPanoramaDelegate {
        public static IStreetViewPanoramaDelegate aa(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
            if (iInterface != null && iInterface instanceof IStreetViewPanoramaDelegate) {
                return (IStreetViewPanoramaDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl2 = 0 != data.readInt();
                    this.enableZoom(bl2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl3 = 0 != data.readInt();
                    this.enablePanning(bl3);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl4 = 0 != data.readInt();
                    this.enableUserNavigation(bl4);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl5 = 0 != data.readInt();
                    this.enableStreetNames(bl5);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl6 = this.isZoomGesturesEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl6 ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl7 = this.isPanningGesturesEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl7 ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl8 = this.isUserNavigationEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl8 ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    boolean bl9 = this.isStreetNamesEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl9 ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    StreetViewPanoramaCamera streetViewPanoramaCamera = 0 != data.readInt() ? StreetViewPanoramaCamera.CREATOR.az(data) : null;
                    long l2 = data.readLong();
                    this.animateTo(streetViewPanoramaCamera, l2);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    StreetViewPanoramaCamera streetViewPanoramaCamera = this.getPanoramaCamera();
                    reply.writeNoException();
                    if (streetViewPanoramaCamera != null) {
                        reply.writeInt(1);
                        streetViewPanoramaCamera.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    String string = data.readString();
                    this.setPositionWithID(string);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.av(data) : null;
                    this.setPosition(latLng);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.av(data) : null;
                    int n2 = data.readInt();
                    this.setPositionWithRadius(latLng, n2);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    StreetViewPanoramaLocation streetViewPanoramaLocation = this.getStreetViewPanoramaLocation();
                    reply.writeNoException();
                    if (streetViewPanoramaLocation != null) {
                        reply.writeInt(1);
                        streetViewPanoramaLocation.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    q q2 = q.a.W(data.readStrongBinder());
                    this.setOnStreetViewPanoramaChangeListener(q2);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    p p2 = p.a.V(data.readStrongBinder());
                    this.setOnStreetViewPanoramaCameraChangeListener(p2);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    r r2 = r.a.X(data.readStrongBinder());
                    this.setOnStreetViewPanoramaClickListener(r2);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    b b2 = b.a.k(data.readStrongBinder());
                    StreetViewPanoramaOrientation streetViewPanoramaOrientation = this.pointToOrientation(b2);
                    reply.writeNoException();
                    if (streetViewPanoramaOrientation != null) {
                        reply.writeInt(1);
                        streetViewPanoramaOrientation.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 19: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    StreetViewPanoramaOrientation streetViewPanoramaOrientation = 0 != data.readInt() ? StreetViewPanoramaOrientation.CREATOR.aC(data) : null;
                    b b3 = this.orientationToPoint(streetViewPanoramaOrientation);
                    reply.writeNoException();
                    reply.writeStrongBinder(b3 != null ? b3.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements IStreetViewPanoramaDelegate {
            private IBinder gm;

            a(IBinder iBinder) {
                this.gm = iBinder;
            }

            public IBinder asBinder() {
                return this.gm;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableZoom(boolean enableZoom) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeInt(enableZoom ? 1 : 0);
                    this.gm.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePanning(boolean enablePanning) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeInt(enablePanning ? 1 : 0);
                    this.gm.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableUserNavigation(boolean enableUserNavigation) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeInt(enableUserNavigation ? 1 : 0);
                    this.gm.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableStreetNames(boolean enableStreetNames) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeInt(enableStreetNames ? 1 : 0);
                    this.gm.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isZoomGesturesEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPanningGesturesEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUserNavigationEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreetNamesEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateTo(StreetViewPanoramaCamera camera, long duration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    if (camera != null) {
                        parcel.writeInt(1);
                        camera.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(duration);
                    this.gm.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StreetViewPanoramaCamera getPanoramaCamera() throws RemoteException {
                StreetViewPanoramaCamera streetViewPanoramaCamera;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    streetViewPanoramaCamera = 0 != parcel2.readInt() ? StreetViewPanoramaCamera.CREATOR.az(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return streetViewPanoramaCamera;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPositionWithID(String panoId) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeString(panoId);
                    this.gm.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPosition(LatLng position) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    if (position != null) {
                        parcel.writeInt(1);
                        position.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.gm.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPositionWithRadius(LatLng position, int radius) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    if (position != null) {
                        parcel.writeInt(1);
                        position.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(radius);
                    this.gm.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StreetViewPanoramaLocation getStreetViewPanoramaLocation() throws RemoteException {
                StreetViewPanoramaLocation streetViewPanoramaLocation;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    this.gm.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    streetViewPanoramaLocation = 0 != parcel2.readInt() ? StreetViewPanoramaLocation.CREATOR.aB(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return streetViewPanoramaLocation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnStreetViewPanoramaChangeListener(q listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.gm.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnStreetViewPanoramaCameraChangeListener(p listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.gm.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnStreetViewPanoramaClickListener(r listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.gm.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StreetViewPanoramaOrientation pointToOrientation(b point) throws RemoteException {
                StreetViewPanoramaOrientation streetViewPanoramaOrientation;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    parcel.writeStrongBinder(point != null ? point.asBinder() : null);
                    this.gm.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    streetViewPanoramaOrientation = 0 != parcel2.readInt() ? StreetViewPanoramaOrientation.CREATOR.aC(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return streetViewPanoramaOrientation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public b orientationToPoint(StreetViewPanoramaOrientation orientation) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate");
                    if (orientation != null) {
                        parcel.writeInt(1);
                        orientation.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.gm.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.k(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }
        }
    }
}

