/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.t;
import com.google.android.gms.maps.internal.u;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class SupportMapFragment
extends Fragment {
    private final b zC = new b(this);
    private GoogleMap yY;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate dZ() {
        this.zC.ea();
        if (this.zC.ca() == null) {
            return null;
        }
        return ((a)this.zC.ca()).dZ();
    }

    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.dZ();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.yY == null || this.yY.dQ().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.yY = new GoogleMap(iGoogleMapDelegate);
        }
        return this.yY;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zC.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zC.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zC.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zC.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zC.onCreateView(inflater, container, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.zC.onResume();
    }

    public void onPause() {
        this.zC.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zC.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zC.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zC.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zC.onSaveInstanceState(outState);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class b
    extends com.google.android.gms.dynamic.a<a> {
        private final Fragment pN;
        protected d<a> zb;
        private Activity pM;

        b(Fragment fragment) {
            this.pN = fragment;
        }

        @Override
        protected void a(d<a> d2) {
            this.zb = d2;
            this.ea();
        }

        public void ea() {
            if (this.pM != null && this.zb != null && this.ca() == null) {
                try {
                    MapsInitializer.initialize((Context)this.pM);
                    IMapFragmentDelegate iMapFragmentDelegate = u.w((Context)this.pM).e(c.g(this.pM));
                    this.zb.a(new a(this.pN, iMapFragmentDelegate));
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.pM = activity;
            this.ea();
        }
    }

    static class a
    implements LifecycleDelegate {
        private final Fragment pN;
        private final IMapFragmentDelegate za;

        public a(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.za = m.f(iMapFragmentDelegate);
            this.pN = m.f(fragment);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.za.onInflate(c.g(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.pN.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    t.a(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.za.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            com.google.android.gms.dynamic.b b2;
            try {
                b2 = this.za.onCreateView(c.g(inflater), c.g(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)c.a(b2);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.za.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.za.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            try {
                this.za.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onDestroy() {
            try {
                this.za.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.za.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.za.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate dZ() {
            return this.za;
        }
    }
}

