/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final a CREATOR = new a();
    private final int nZ;
    private Boolean yN;
    private Boolean yO;
    private int yP = -1;
    private CameraPosition yQ;
    private Boolean yR;
    private Boolean yS;
    private Boolean yT;
    private Boolean yU;
    private Boolean yV;
    private Boolean yW;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.nZ = versionCode;
        this.yN = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.yO = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.yP = mapType;
        this.yQ = camera;
        this.yR = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.yS = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.yT = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.yU = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.yV = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.yW = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.em()) {
            b.a(this, out, flags);
        } else {
            a.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.nZ;
    }

    byte dR() {
        return com.google.android.gms.maps.internal.a.b(this.yN);
    }

    byte dS() {
        return com.google.android.gms.maps.internal.a.b(this.yO);
    }

    byte dT() {
        return com.google.android.gms.maps.internal.a.b(this.yR);
    }

    byte dU() {
        return com.google.android.gms.maps.internal.a.b(this.yS);
    }

    byte dV() {
        return com.google.android.gms.maps.internal.a.b(this.yT);
    }

    byte dW() {
        return com.google.android.gms.maps.internal.a.b(this.yU);
    }

    byte dX() {
        return com.google.android.gms.maps.internal.a.b(this.yV);
    }

    byte dY() {
        return com.google.android.gms.maps.internal.a.b(this.yW);
    }

    public GoogleMapOptions() {
        this.nZ = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.yN = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.yO = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.yP = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.yQ = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.yR = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.yS = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.yT = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.yU = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.yV = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.yW = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.yN;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.yO;
    }

    public int getMapType() {
        return this.yP;
    }

    public CameraPosition getCamera() {
        return this.yQ;
    }

    public Boolean getZoomControlsEnabled() {
        return this.yR;
    }

    public Boolean getCompassEnabled() {
        return this.yS;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.yT;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.yU;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.yV;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.yW;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

