/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.bk;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String ul = null;
        private int um = 0;
        private long un = Long.MIN_VALUE;
        private short uo = (short)-1;
        private double up;
        private double uq;
        private float ur;
        private int us = 0;
        private int ut = -1;

        public Builder setRequestId(String requestId) {
            this.ul = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.um = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.un = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.uo = 1;
            this.up = latitude;
            this.uq = longitude;
            this.ur = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.us = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.ut = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.ul == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.um == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.um & 4) != 0 && this.ut < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.un == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.uo == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.us < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new bk(this.ul, this.um, 1, this.up, this.uq, this.ur, this.un, this.us, this.ut);
        }
    }
}

